#!/bin/bash

[ -z "${WORK_USER}" ] && WORK_USER='ossadm'

function fn_check_env()
{
    local ret=0
    local sudobin_path=$1
    local tmp_msg=$(df --output=pcent,target | awk '$1=="100%" && ($2=="/") {print $0}')
    if [ ! -z "${tmp_msg}" ]
    then
        PRINT_LOG "FATAL" "content=${tmp_msg},The disk space is full."
        [[ ${ERROR_CODE} =~ "UpgradeSudoconfig000001 " ]] || ERROR_CODE="${ERROR_CODE} UpgradeSudoconfig000001 "
        ret=11
    fi

    local tmp_msg=$(stat -c "%U:%G %n" / /root | grep -vw "root:root")
    if [ ! -z "${tmp_msg}" ]
    then
        PRINT_LOG "FATAL" "content=${tmp_msg}, The directory owner group is incorrect."
        [[ ${ERROR_CODE} =~ "UpgradeSudoconfig000002 " ]] || ERROR_CODE="${ERROR_CODE} UpgradeSudoconfig000002 "
        ret=12
    fi

    local tmp_msg=$(stat -c "%A %n" / /root | cut -c9- | grep '^w')
    if [ ! -z "${tmp_msg}" ]
    then
        PRINT_LOG "FATAL" "content=${tmp_msg},The directory permission is incorrect."
        [[ ${ERROR_CODE} =~ "UpgradeSudoconfig000003 " ]] || ERROR_CODE="${ERROR_CODE} UpgradeSudoconfig000003 "
        ret=13
    fi

    fn_check_mode ${sudobin_path}
    if [ $? -ne 0 ]
    then
        PRINT_LOG "FATAL" "sudobinpath:<${sudobin_path}> directory or parent directory mode is incorrect."
        [[ ${ERROR_CODE} =~ "UpgradeSudoconfig000004 " ]] || ERROR_CODE="${ERROR_CODE} UpgradeSudoconfig000004 "
        ret=15
    fi

    return "${ret}"
}

function fn_check_mode()
{
    local folder="$1"
    local mode=$(stat -c %A "${folder}")
    local other_mode=$(echo ${mode:0-3:3} | grep w)
    local owner_mode=$(stat -c %U:%G "${folder}")

    if [ "${owner_mode}" = "root:root" ] && [ -z "${other_mode}" ]
    then
        [ "${folder}" = "/" ] && return 0
        local parent_folder=$(dirname "${folder}")
        fn_check_mode "${parent_folder}" || { echo "${folder}:${owner_mode}:${other_mode}"; return 1; }
    else
        echo "${folder}:${owner_mode}:${other_mode}"
        return 15
    fi

    return 0
}

function record_syslog()
{
    local ret_code="$1"
    local script_name="$2"
    if [ ${ret_code} -eq 0 ]
    then
        logger -t ${USER} -p local0.info "${script_name};Successful;${OPERIP:-127.0.0.1};Execute script ${script_name}"
    else
        logger -t ${USER} -p local0.err "${script_name};Failed;${OPERIP:-127.0.0.1};Execute script ${script_name}"
    fi
}

