#!/bin/bash

managerip=$(grep "^managerip" /opt/oss/manager/var/agent/managerip.conf | awk -F'=|,' '{print $2}')
networkIP=$(ifconfig 2>/dev/null | grep "inet" | grep -v "127.0.0.1" | awk '{print $2}')

isOMPIP="False"
for ethIP in ${networkIP};do
    echo ${managerip} | grep ${ethIP} >/dev/null 2>&1
    if [ $? -eq 0 ];then
        isOMPIP="True"
    fi
done
if [ -f "/etc/uuid/uuid.txt" ];then
    grep "0" "/etc/uuid/uuid.txt" >/dev/null 2>&1
    if [ $? -eq 0 ];then
        isOMPIP="True"
    fi
fi

if [ "${isOMPIP}" == "True" ];then
    echo "check is OMP_01 success"
    exit 0
fi
echo "check is OMP_01 failure"
exit 1
