#!/bin/bash
#==============================================================
# Copyright  Huawei Technologies Co., Ltd. 1998-2018. All rights reserved.
# File Name             : setNicForEuler.sh
# Version:Data          : 28-12-2018  
# Description           : Configure network for the system
# Others                : 
# History               : 
#==============================================================

getWorkPath()
{
    dir=`dirname $0`
    ispointstart=`echo $dir|awk -F/ '{print $1}'`
    if [ "$ispointstart" = "." ]
    then
        dir=`echo $dir|sed 's/^.//'`
        dir=`echo $dir|sed 's/^.//'`
        workfolder="`pwd`$dir"
    elif [ "$ispointstart" = ".." ]
    then
        workfolder="`pwd`/$dir"
    else
        workfolder="$dir"
    fi
}
getWorkPath

delete_tmpfile()
{
    rm -rf /tmp/cardnames
    rm -rf /tmp/cardnames_bak
    rm -rf /tmp/ifcfg-bond
    rm -rf /tmp/networkcardnames
    rm -rf /tmp/inet_netmask
    rm -rf /tmp/usednetworkcardnames
}

checkuser()
{
    USERNAME=`id | grep root`
    if [ -z "${USERNAME}" ]
    then
        echo "User is not root User,Please log in to the system as the root user!"
        exit 1
    fi
}

getTime()
{
    MONTH=`$date +%m`
    DAY=`$date +%d`
    HOUR=`$date +%H`
    MIN=`$date +%M`
    Time="$MONTH""$DAY""$HOUR""$MIN"
    echo "$Time"
}


check_IP()
{

    if [ $# -ne 1 ]
    then
        return 1
    fi


    echo "$1" | grep \
     '^\([0-9]\{1,3\}\.\)\([0-9]\{1,3\}\.\)\([0-9]\{1,3\}\.\)[0-9]\{1,3\}$' > /dev/null
    if [ $? -eq 1 ]
    then
        return 1
    fi


    _TMP_RESULT=`echo "$1" | awk 'BEGIN {split('"\"$1\""', \
     filearray, ".")}{for(i in filearray){if(filearray[i] > 255) print filearray[i]}}'`
    if [ -n "$_TMP_RESULT" ]
    then 
        echo "The value of ip address($1) is error, please check it."
        return 1
    fi
    return 0
}

D2B()
{
    x="$1"
    d2b=`echo "obase=2;$x" | bc`
    echo $d2b
}

check_netmask()
{
    nip=$1
    eval `echo $nip | awk -F. '{print "a="$1";b="$2";c="$3";d="$4}'`
    a=`D2B $a`
    b=`D2B $b`
    c=`D2B $c`
    d=`D2B $d`
    for i in $a $b $c $d
    do
        if [ $i != 0 -a ${#i} != 8 ]
        then
            return 1
        fi
    done
    nip2=$a$b$c$d
    if [ "$nip2" = "0000" ]
    then
        return 0
    fi
    [[ "$nip2" =~ ^1[1]*[0]*$ ]] && return 0 || return 1
}

getusedcard()
{
    > /tmp/ifcfg-bond
    ip addr|grep "inet" |grep eth |awk  '{print $(NF)}'>> /tmp/ifcfg-bond
}

select_used_network_card()
{
    usednetworkcardnames=/tmp/usednetworkcardnames
    getusedcard
    cat /tmp/ifcfg-bond | cat -n > "$usednetworkcardnames"
    nicCount=`cat "$usednetworkcardnames" | wc -l`
    if [ ! -f "$usednetworkcardnames" -o ! -s "$usednetworkcardnames" ]
    then
        echo "There is no available NIC."
        exit 1
    fi
    
    while [ 0 ]
    do
        echo "The NICs used in the local server are as follows:"    
        echo "-------------------------------------------"
        cat $usednetworkcardnames | awk '{print "             "$1"            "$2}'
        echo "-------------------------------------------"
                
        echo "Please enter a number to select the system NIC[1-${nicCount}]:"
        read network_card_num
        network_card_name=`cat "$usednetworkcardnames" | awk '{if($1=="'$network_card_num'") print $2}'`

        if [ -z  "$network_card_name" ]
        then            
            echo "The inputed number \"${network_card_num}\" is invalid!"
            continue
        fi
        oldip=`ifconfig $network_card_name | grep -w "inet" | awk '{print $2}'`
        break             
    done    
    return 0
}

select_unuse_network_card()
{
    networkcardnames="/tmp/networkcardnames"
    getusedcard
    ifconfig -a |grep ": " |grep eth |awk -F: '{print $1}' > /tmp/cardnames
    cat /tmp/ifcfg-bond | while read line
    do
        cat /tmp/cardnames | grep -v "^${line}$" > /tmp/cardnames_bak
        mv /tmp/cardnames_bak /tmp/cardnames
    done
    cat /tmp/cardnames | cat -n > "$networkcardnames"
    nicCount=`cat "$networkcardnames" | wc -l`
    if [ ! -f "$networkcardnames" -o ! -s "$networkcardnames" ]
    then
        echo "There is no available NIC."
        exit 1
    fi
    while [ 0 ]
    do
        echo "The NICs available in the local server are as follows:"    
        echo "-------------------------------------------"
        cat $networkcardnames | awk '{print "             "$1"            "$2}'
        echo "-------------------------------------------"
        echo "Please enter a number to select the system NIC[1-${nicCount}]:"
        read network_card_num
        network_card_name=`cat "$networkcardnames" | awk '{if($1=="'$network_card_num'") print $2}'`

        if [ -z  "$network_card_name" ]
        then            
            echo "The inputed number \"${network_card_num}\" is invalid!"
            continue
        fi
        break             
    done    
    return 0
}

check_HOSTNAME()
{
    if [ $# -ne 1 ]
    then
        echo "Please provide a hostname to check."
        return 1
    fi
    len=`echo $1 | awk '{print length($0)}'`
    if [ "$len" -gt 64 ]
    then
        echo "The host name cannot exceed 64 characters."
        return 1
    fi
    
    echo $1 | egrep '^[a-zA-Z]+[0-9a-zA-Z-]*[0-9a-zA-Z]+$' >/dev/null 2>&1 
    if [ $? -ne 0 ]
    then
        echo "The host name can contain only digits, letters, and hyphens(-)."
        return 1
    fi
    
    echo $1 | egrep '\-\-' >/dev/null 2>&1 
    if [ $? -eq 0  ]
    then
        echo "The host name cannot contain \"--\"."
        return 1
    fi
    return 0
}

check_ip_netmask()
{
    all_Par=(${@//[!0-9]/ })
    [ "${#all_Par[@]}" != "8" ] && {
    echo "Usage: "
    echo "${0##*/} ip.ip.ip.ip/mask.mask.mask.mask"
    exit 1
    }
}

get_addr() 
{
    if [ "$1" = "-b" ]; then
        op='|'; op1='^'; arg='255'
        shift
    else
        op='&'
    fi
    unset address_ip
    while [ "$5" ]; do
    num=$(( $1 $op ($5 $op1 $arg) ))
    shift
    address_ip="$address_ip.$num"
    done
}

network_ip_config()
{
    _RST=1
    while [ $_RST -eq 1  ]
    do
        _RST=0
        if [ $_RST -eq 0 ]
        then
            _IPFLAG=1
             echo "Please input the IP address:"
             ipCount=0
            while [ $_IPFLAG -eq 1 ]
            do
                read _NEWIP
                check_IP $_NEWIP
                if [ $? -ne 0 ]
                then
                    echo "Error,the given IP \"$_NEWIP\" is illegal."
                    echo "Please input the IP address:"
                    ipCount=`expr $ipCount + 1`
                    if [ $ipCount = "3" ]
                    then
                        exit 1
                    else
                    continue
                    fi 
                fi
                ifconfig -a | grep "inet addr:" | awk '{print $2}' | awk -F":" '{print $2}' | grep -w $_NEWIP > /dev/null
                if [ $? -eq 0 ]
                then
                    echo "$_NEWIP has been used!"
                    echo "Please input the IP address:"
                    continue 
                fi                
                echo "$_NEWIP" | egrep '^127|^255|^0' > /dev/null
                if [ $? -eq 1 ]
                then
                    _IPFLAG=0
                else
                    echo "Error,the given IP \"$_NEWIP\" is illegal."    
                    echo "Please input the IP address:"
                fi                
            done
        fi
    done
     _RST=1
    while [ $_RST -eq 1 ]
    do
        _RST=0
        if [ $_RST -eq 0 ]
        then
            _IPFLAG=1
            echo "Please input the subnet mask:"
            networkCount=0
            while [ $_IPFLAG -eq 1 ]
            do
                read _NEWMASK
                _NEWMASK=`echo $_NEWMASK`
                check_IP $_NEWMASK
                if [ $? -ne 0 ]
                then
                    echo "Error! The given subnet mask \"$_NEWMASK\" is illegal."
                    echo "Please input the subnet mask:"
                    networkCount=`expr $networkCount + 1`
                    if [ $networkCount = "3" ]
                    then
                        exit 1
                    else
                    continue
                    fi
                fi

                >/tmp/inet_netmask 
                ifconfig -a | grep "inet addr:" | grep "Bcast:" | awk '{print $2}' | awk -F":" '{print $2}' | while read line
                do
                    inet_netmask=`ifconfig -a | grep "$line" |  awk '{print $4}' | awk -F":" '{print $2}'`
                    check_ip_netmask "$line" "$inet_netmask"
                    get_addr ${all_Par[@]}                    
                    echo -e "$line\t${address_ip#.}" >> /tmp/inet_netmask
                done
                check_ip_netmask $_NEWIP $_NEWMASK
                get_addr ${all_Par[@]}
                cat /tmp/inet_netmask | while read line
                do 
                    echo "$line" | awk '{print $2}' | grep "^${address_ip#.}$" > /dev/null 2>&1                
                    if [ $? -eq 0 ]
                    then
                        __ip=`echo "$line" | awk '{print $1}'`
                        echo "The selected ip $_NEWIP belongs to the same subnet as the ip $__ip!"
                        echo "100" > /tmp/__flag
                        break
                    fi
                done

                if [ ! -f /tmp/__flag ]
                then
                    check_netmask $_NEWMASK
                    if [ $? -eq 0 ]
                    then
                        _IPFLAG=0
                    else
                        echo "Error! The given subnet mask \"$_NEWMASK\" is illegal."
                        echo "Please input the subnet mask:"   
                    fi
                fi
                if [ -f /tmp/__flag ]
                then
                    break
                fi
            done
        fi        
    done
}    

network_route_config()
{
    route_Flag=0
    printf "Do you need to configure the route for $network_card_name ?[Y:Yes, N:No, N]: "
    read choice
    if [ "${choice}" = "Y" -o "${choice}" = "y" ]
    then
        _RST=1
        while [ $_RST -eq 1  ]
        do
            _RST=0
            if [ $_RST -eq 0 ]
            then
                _IPFLAG=1
                 echo "Please input the GATEWAY address:"
                 ipCount=0
                while [ $_IPFLAG -eq 1 ]
                do
                    read _GATEWAY
                    check_IP $_GATEWAY
                    if [ $? -ne 0 ]
                    then
                        echo "Error,the given GATEWAY \"$_GATEWAY\" is illegal."
                        echo "Please input the GATEWAY address:"
                        ipCount=`expr $ipCount + 1`
                        if [ $ipCount = "3" ]
                        then
                            exit 1
                        else
                        continue    
                        fi  
                    fi
                    echo "$_GATEWAY" | egrep '^127|^255|^0' > /dev/null
                    if [ $? -eq 1 ]
                    then
                        _IPFLAG=0
                    else
                        echo "Error,the given GATEWAY \"$_GATEWAY\" is illegal."    
                        echo "Please input the GATEWAY address:"
                    fi
                done
            fi
        done

        _RST=1
        while [ $_RST -eq 1  ]
        do
            _RST=0
            if [ $_RST -eq 0 ]
            then
                _IPFLAG=1
                 echo "Please input the destination network segment:"
                 ipCount=0
                while [ $_IPFLAG -eq 1 ]
                do
                    read _Destination
                    check_IP $_Destination
                    if [ $? -ne 0 ]
                    then
                        echo "Error,the given Destination \"$_Destination\" is illegal."
                        echo "Please input the Destination address:"
                        ipCount=`expr $ipCount + 1`
                        if [ $ipCount = "3" ]
                        then
                            exit 1
                        else
                        continue
                        fi  
                    fi
                    echo "$_Destination" | egrep '^127|^255' > /dev/null
                    if [ $? -eq 1 ]
                    then
                        _IPFLAG=0
                    else
                        echo "Error,the given Destination \"$_Destination\" is illegal."    
                        echo "Please input the Destination address:"
                    fi                
                done
            fi
        done

        _RST=1
        while [ $_RST -eq 1 ]
        do
            _RST=0
            if [ $_RST -eq 0 ]
            then
                _IPFLAG=1
                echo "Please input the Genmask:"
                networkCount=0
                while [ $_IPFLAG -eq 1 ]
                do
                    read _Genmask
                    _Genmask=`echo $_Genmask`
                    check_IP $_Genmask
                    if [ $? -ne 0 ]
                    then
                        echo "Error! The given _Genmask \"$_Genmask\" is illegal."
                        echo "Please input the _Genmask:"
                        networkCount=`expr $networkCount + 1`
                        if [ $networkCount = "3" ]
                        then
                            exit 1
                        else
                        continue
                        fi
                    fi

                    >/tmp/inet_netmask 
                    check_ip_netmask "$_Destination" "$_Genmask"
                    get_addr ${all_Par[@]}                    
                    echo -e "$line\t${address_ip#.}" >> /tmp/inet_netmask
                    check_ip_netmask $_Destination $_Genmask
                    get_addr ${all_Par[@]}
                    cat /tmp/inet_netmask | while read line
                    do 
                        echo "$line" | awk '{print $2}' | grep "^${address_ip#.}$" > /dev/null 2>&1                
                        if [ $? -eq 0 ]
                        then
                            __ip=`echo "$line" | awk '{print $1}'`
                            echo "The selected ip $_NEWIP belongs to the same subnet as the ip $__ip!"
                            echo "100" > /tmp/__flag
                            break
                        fi
                    done

                    if [ ! -f /tmp/__flag ]
                    then
                        check_netmask $_Genmask
                        if [ $? -eq 0 ]
                        then
                            _IPFLAG=0
                        else
                            echo "Error! The given _Genmask \"$_Genmask\" is illegal."
                            echo "Please input the _Genmask:"   
                        fi
                    fi
                    if [ -f /tmp/__flag ]
                    then
                        break
                    fi
                done
            fi        
        done
        route_Flag=1
    fi
}
    
hostname_config()
{
    hostname_Flag=0
    oldhostname=`hostname`
    printf "Do you need to configure the hostname?[Y:Yes, N:No, N]: "
    read choice
    if [ "${choice}" = "Y" -o "${choice}" = "y" ]
    then
        if [ ! -f /tmp/__flag ]
        then

            _RST=1
            while [ $_RST -eq 1  ]
            do
                _RST=0
                if [ $_RST -eq 0 ]
                then
                    _IPFLAG=1
                    echo "Please input the hostip:"
                    read _HOSTIP
                    echo "Please input the hostname:"
                    hostCount=0
                    while [ $_IPFLAG -eq 1 ]
                    do
                        read _NEWHS
                        cat /etc/hosts | grep -v "^#" |  awk '{print $2}' | grep -v "^localhost" | grep -w "^$_NEWHS$" > /dev/null 2>&1
                        if [ $? -eq 0 ]
                        then
                            echo "This name $_NEWHS already exists!"
                            echo "Please input the hostname:"
                            continue
                        fi
                        check_HOSTNAME $_NEWHS
                        if [ $? -eq 0 ]
                        then
                            _IPFLAG=0
                        else
                            echo "Error,the given hostname \"${_NEWHS}\" is illegal." 
                            echo "Please input the hostname:"
                            hostCount=`expr $hostCount + 1`
                            if [ $hostCount = "3" ]
                            then
                                exit 1
                            else
                                continue
                            fi
                        fi
                    done
                fi
            done
        fi
        hostname_Flag=1
    fi
    
    if [ -f /tmp/__flag ]
    then
        rm -rf /tmp/__flag
        return 1
    fi
    return 0
}


add_network()
{
    rm -rf /etc/sysconfig/network-scripts/ifcfg-$network_card_name
    touch /etc/sysconfig/network-scripts/ifcfg-$network_card_name
    cat >> /etc/sysconfig/network-scripts/ifcfg-$network_card_name <<EOF
TYPE=Ethernet
PROXY_METHOD=none
BROWSER_ONLY=no
BOOTPROTO='static'
DEFROUTE=yes
IPV4_FAILURE_FATAL=no
IPV6INIT=yes
IPV6_AUTOCONF=yes
IPV6_DEFROUTE=yes
IPV6_FAILURE_FATAL=no
IPV6_ADDR_GEN_MODE=stable-privacy
ONBOOT='yes'
NAME=' Huawei Technologies Co., Ltd. Device d110'
EOF
    echo "DEVICE=$network_card_name" >> /etc/sysconfig/network-scripts/ifcfg-$network_card_name
    echo "IPADDR='$_NEWIP'" >> /etc/sysconfig/network-scripts/ifcfg-$network_card_name
    echo "NETMASK='$_NEWMASK'" >> /etc/sysconfig/network-scripts/ifcfg-$network_card_name
    if [ $route_Flag -eq 1 ]
    then
        rm -rf /etc/sysconfig/network-scripts/route-$network_card_name
        touch /etc/sysconfig/network-scripts/route-$network_card_name
        echo "ADDRESS0=$_Destination">>/etc/sysconfig/network-scripts/route-$network_card_name
        echo "NETMASK0=$_Genmask">>/etc/sysconfig/network-scripts/route-$network_card_name
        echo "GATEWAY0='$_GATEWAY'">>/etc/sysconfig/network-scripts/route-$network_card_name
    fi
    
    if [ $hostname_Flag -eq 1 ]
    then
        hostnamectl --static set-hostname $_NEWHS
        if [ -f /etc/hosts ]
        then
            echo -e "$_NEWIP\t$_NEWHS" >> /etc/hosts
        fi
    fi

    echo "Begin to Configured the NIC ..."
    systemctl restart network
    ifconfig $network_card_name up >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        echo "Configured the NIC successfully."
    else
        echo "Configured the NIC failed."
    fi 
}

set_hostname()
{
    if [ $hostname_Flag -eq 1 ]
    then
        hostnamectl --static set-hostname $_NEWHS
        if [ -f /etc/hosts ]
        then
            echo -e "$_HOSTIP\t$_NEWHS" >> /etc/hosts
        fi
    fi

    if [ $? -eq 0 ]
    then
        echo "Configured the Hostname successfully."
    else
        echo "Configured the Hostname failed."
    fi 
}

AddIP_setup()
{
    checkuser
    select_unuse_network_card
    network_ip_config
    network_route_config
    hostname_config
    add_network
    delete_tmpfile
}

ModifyIP_setup()
{
    checkuser
    select_used_network_card
    network_ip_config
    network_route_config
    hostname_config
    if [ $hostname_Flag -eq 0 ]
    then
        hostname_Flag=0
        cat /etc/hosts | grep -w "$oldip" >/dev/null 2>&1
        if [ $? -eq 0 ]
        then
            eval sed -i '/"$oldhostname"/d' /etc/hosts
            echo -e "$_NEWIP\t$oldhostname" >> /etc/hosts
        fi
    fi
    add_network
    delete_tmpfile
}

SetHostname_setup()
{
    hostname_config
    set_hostname
    delete_tmpfile
}

Main()
{
    run_Flag=1
    while [ $run_Flag -eq 1 ]
    do
        printf "Do you want to add IP for the system or modify the nic IP?[1:Add, 2:modify, 3:JustSetHostName, 1]: "
        read choice
        if [ "${choice}" = "1" -o "${choice}" = "" ]
        then
            AddIP_setup
            run_Flag=0
        elif [ "${choice}" = "2" ]
        then
            ModifyIP_setup
            run_Flag=0
        elif [ "${choice}" = "3" ]
        then
            SetHostname_setup
            run_Flag=0        
        else
            echo -e "\nWARNING: Please input a valid option."
            run_Flag=1
        fi
    done
}

Main $@ 

