#!/bin/bash

checkOS()
{
  OSType=""
  if [ -f /etc/SuSE-release ]
  then
    OSType="suse"
  elif [ -f /etc/centos-release ] && [ "`grep CentOS /etc/centos-release`"]
  then
    OSType="centos"
  elif [ -f /etc/euleros-release ]
  then
    OSType="EulerOS"
  elif [ -f /etc/rethad-release ]
  then
    OSType="redhatOS"
  else
    OSType="others"
  fi

  if [ "${OSType}" != "EulerOS" ]
  then
    return 1
  fi

  return 0
}

Main()
{
    checkOS
    if [ $? -ne 0 ]
    then
      rm -rf /opt/expansion/os_patch/ > /dev/null 2>&1
      echo "No patch is required for non-EulerOS."
      return 0
    fi

    temp1="/opt/expansion/os_patch/temp1"
    temp2="/opt/expansion/os_patch/temp2"
    temp3="/opt/expansion/os_patch/temp3"
    mkdir -p ${temp1} ${temp2} ${temp3}

    pkg_os_patch_euler=$1

    cd /opt/expansion/os_patch/
    tar -xvf ${pkg_os_patch_euler} -C ${temp1} > /dev/null 2>&1

    cd ${temp1}/
    tar -zxvf *.tar.gz -C ${temp2} > /dev/null 2>&1

    cd ${temp2}/
    tar -zxvf *.tar.gz -C ${temp3} > /dev/null 2>&1

    cd ${temp3}/
    cd $(find . -name *Patch -type d)/
    tar xvf os_sudobin_pkg.tar > /dev/null 2>&1
    tar xvf os_sudobin.tar > /dev/null 2>&1
    cd script/
    chmod 550 update_euler_do.sh
    bash update_euler_do.sh

    if [ $? -ne 0 ]
    then
        echo "Error: config EulerOS patch package failed" 1>&2
        return 1
    else
        echo "config EulerOS patch package succeed"
    fi

    rm -rf /opt/expansion/os_patch/ > /dev/null 2>&1
    # ospatch补丁版本需要删除该目录
    rm -rf /opt/patch_manager > /dev/null 2>&1
    return 0
}

Main $*