#!/bin/bash
# 添加产品后置检查
MODULE_NAME=$1
CURPATH=$2
BASHPID=$$

LOG_FILE="${CURPATH}/${MODULE_NAME}.log"
if [ ! -f ${LOG_FILE} ]
then
    touch ${LOG_FILE}
    chmod 640 ${LOG_FILE}
    chown ossadm:ossgroup ${LOG_FILE}
fi

# log
function operate_log()
{
    local level=$1
    local log_msg=$2
    
    echo ${level} | grep -i "ERROR" &>/dev/null
    if [ $? -eq 0 ]
    then
        local level="ERROR"
    fi
    echo ${level} | grep -i "WARN" &>/dev/null
    if [ $? -eq 0 ]
    then
        local level="WARN"
    fi
    if [ -z "${level}" ]
    then
        local level="INFO"
    fi

    echo "[$(date '+%Y-%m-%d %H:%M:%S')] [${BASHPID}] | ${level} ${log_msg}" | tee -a ${LOG_FILE}
}

# 检查ipv4和ipv6 IP格式
function check_ip()
{
    [[ $1 =~ ^([1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([1-9]?[0-9]|1[0-9][0-9]?|2[0-4][0-9]|25[0-5])){3}$ ]]  ||\
    [[ $1 =~ ^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$ ]]
}

# 检查已纳管配置互信后节点coredump目录
function check_node()
{
    local node_ip=$1
    local coredump="/opt/oss/log/NCE/coredump"
    # 创建coredump目录,并修改权限
    cmd="[ ! -d ${coredump} ] && mkdir -p ${coredump};chmod 750 ${coredump};setfacl -m u:ossuser:rwx ${coredump}"
    ssh ossadm@${node_ip} -o stricthostkeychecking=no "${cmd}"  &>/dev/null
    [ $? -ne 0 ] && return 1
    return 0
}

# 添加产品后置检查
function post_check()
{
    # 初始化工具模块
    local get_product_info="${CURPATH}/get_product_info.py"
    if [ ! -f ${get_product_info} ]
    then
        local get_product_info="${CURPATH}/get_product_info.pyc"
        if [ ! -f ${get_product_info} ]
        then
            operate_log "error" "Error: The get_product_info.pyc module is not found.."
            return 1
        fi
    fi
    
    # 导入环境变量
    source /opt/oss/manager/bin/engr_profile.sh
    # 获取所有节点IP
    local node_ip_list=$(python ${get_product_info})
    if [ -z "${node_ip_list}" ]
    then
        operate_log "error" "Error: Failed to obtain the product node information."
        return 1
    fi
    
    # 遍历检查,以保证所有节点coredump存在,且权限正常
    local result_flag=0
    for node_ip in $(echo ${node_ip_list} | sed 's/,/ /g')
    do
        check_ip "${node_ip}" &>/dev/null
        if [ $? -ne 0  ]
        then
            operate_log "error" "Error: msg: ${node_ip}."
            local result_flag=1
            break
        fi
        check_node "${node_ip}" &>/dev/null
        if [ $? -eq 0 ]
        then
            operate_log "INFO" "Check whether the /opt/oss/log/NCE/coredump directory on the ${node_ip} node is normal."
        else
            local result_flag=1
            operate_log "error" "The /opt/oss/log/NCE/coredump directory on the ${node_ip} node is abnormal."
            
        fi
        sleep 0.5
    done
    return ${result_flag}
}

post_check
exit $?
