#!/bin/bash
#install dir

. ./read_pw.sh

installDir=/opt/install
ip_adapter=""
standbyip_adapter=""
thirdip_adapter=""
MODULE_NAME="$(basename $0)"
USER=$(whoami)
#uniep package
GetUniepPackageName()
{
    uniepPackage="iMasterNCE.*\OMP_linux-.*64.zip"
    if [  -n "${productname}" ]
    then
        uniepPackage=".*${productname}.*\OMP_linux-.*64.zip"
    fi
}

#create action.json check file
createCheckFile()
{
    echo "#!/bin/bash" >/opt/install/check_manager_result.sh
    echo "echo  RESULT:1" >>/opt/install/check_manager_result.sh
    chmod 750 /opt/install/check_manager_result.sh
}

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

logFile="${curPath}/${MODULE_NAME}.log"

getcheckResult()
{
   if [ $1 -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf /opt/install/check_manager_result.sh
   ">/opt/install/check_manager_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf /opt/install/check_manager_result.sh
   ">/opt/install/check_manager_result.sh
   fi
   chmod 750 /opt/install/check_manager_result.sh > /dev/null 2>&1
   return $1
}

checkLocalIp()
{
    [[ $1 =~ ^([1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([1-9]?[0-9]|1[0-9][0-9]?|2[0-4][0-9]|25[0-5])){3}$ ]]  ||\
    [[ $1 =~ ^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$ ]]

}

checkLocalIPExist()
{
    ippaddr=$1
    [ "$ippaddr" == "" -o "$ippaddr" == "127.0.0.1" -o "$ippaddr" == "::1" ] && return 1

    # adapt to ipv4 ipv6 SuSE and euler
    localIp=`${IFCONFIG_PATH} -a|${GREP_PATH} inet|${SED_PATH} "s/addr://;s^/^ ^"|${AWK_PATH} '{print $2}'|${GREP_PATH} "^$ippaddr$"`
    if [ -z "${localIp}" ]
    then
        echo -e "The IP $ippaddr is not find in this node!"
        return 1
    fi
}

getInput()
{
    #多OMP场景卸载备OMP节点
    echo "${ExecParam}" | grep 'standbyip' >/dev/null 2>&1
    if [ $? -eq 0 ];then
        echo "es_input: os_pwd_root"
        read os_pwd_root
        echo "es_input: node_2_root_pwd"
        read node_2_root_pwd
        if [ -z "$node_2_root_pwd" ];then
            node_2_root_pwd=${os_pwd_root}
        fi
        echo "es_input: node_3_root_pwd"
        read node_3_root_pwd
        if [ -z "$node_3_root_pwd" ];then
            node_3_root_pwd=${os_pwd_root}
        fi
    fi
}


#checkInputParam: install_nce.sh icmr / install_nce.sh -ip xx -lang xx
CheckInstallPara()
{
    for i in {1..28}
    do
        [[ ${1#-} == "ip" ]] && { ip=$2;shift 2;continue; }
        [[ ${1#-} == "version" ]] && { version=$2;shift 2;continue; }
        [[ ${1#-} == "accessip" ]] && { accessip=$2;shift 2;continue; }
        [[ ${1#-} == "accessip2" ]] && { accessip2=$2;shift 2;continue; }
        [[ ${1#-} == "lang" ]] && { lang=$2;shift 2;continue; }
        [[ ${1#-} == "standbyip" ]] && { standbyip=$2;shift 2;continue; }
        [[ ${1#-} == "thirdip" ]] && { thirdip=$2;shift 2;continue; }
        [[ ${1#-} == "fourthip" ]] && { fourthip=$2;shift 2;continue; }
        [[ ${1#-} == "fifthip" ]] && { fifthip=$2;shift 2;continue; }
        [[ ${1#-} == "accessnic" ]] && { accessnic=$2;shift 2;continue; }
        [[ ${1#-} == "accessnic2" ]] && { accessnic2=$2;shift 2;continue; }
        [[ ${1#-} == "accessnetmask" ]] && { accessnetmask=$2;shift 2;continue; }
        [[ ${1#-} == "accessnetmask2" ]] && { accessnetmask2=$2;shift 2;continue; }
        [[ ${1#-} == "mode" ]] && { mode=$2;shift 2;continue; }
        [[ ${1#-} == "azname" ]] && { azname=$2;shift 2;continue; }
        [[ ${1#-} == "scalesize" ]] && { scalesize=$2;shift 2;continue; }
        [[ ${1#-} == "networkinfo" ]] && { networkinfo=$2;shift 2;continue; }
        [[ ${1#-} == "ommhaheartip" ]] && { ommhaheartip=$2;shift 2;continue; }
        [[ ${1#-} == "productname" ]] && { productname=$2;shift 2;continue; }
        [[ ${1#-} == "HA_OPEN" ]] && { DR_HA_OPEN=$2;shift 2;continue; }
        [[ ${1#-} == "VIP_OPEN" ]] && { DR_VIP_OPEN=$2;shift 2;continue; }
        [[ ${1#-} == "DEPLOY_MODE" ]] && { DEPLOY_MODE=$2;shift 2;continue; }
        [[ ${1#-} == "APP_ARBI_ON" ]] && { APP_ARBI_ON=$2;shift 2;continue; }
        [[ ${1#-} == "pkglist" ]] && { pkglist=$2;shift 2;continue; }
        [[ ${1#-} == "deployexpired" ]] && { deployexpired="${2}";shift 2;continue; }
        [[ ${1#-} == "drnetworktype" ]] && { drnetworktype="${2}";shift 2;continue; }
        [[ ${1#-} == "extpkg" ]] && { extpkg=$2;shift 2;continue; }
        [[ ${1#-} == "commonCertExtendedKeyUsage" ]] && { commonCertExtendedKeyUsage=$2;shift 2;continue; }
    done

    ExecParam=
    if [ "X${ip}" != "X" ];then
        checkLocalIp ${ip} || return 1
        ExecParam=`echo ${ExecParam} -ip ${ip}`
    fi

    if [ "X${accessip}" != "X" ];then
        ExecParam=`echo ${ExecParam} -accessip ${accessip}`
    fi

    if [ "X${accessip2}" != "X" ];then
        ExecParam=`echo ${ExecParam} -accessip2 ${accessip2}`
    fi

    if [ "X${lang}" != "X" ];then
        ExecParam=`echo ${ExecParam} -lang ${lang}`
    fi

    if [ "X${standbyip}" != "X" ];then
        ExecParam=`echo ${ExecParam} -standbyip ${standbyip}`
    fi

    if [ "X${thirdip}" != "X" ];then
        ExecParam=`echo ${ExecParam} -thirdip ${thirdip}`
    fi

    if [ "X${fourthip}" != "X" ];then
        ExecParam=`echo ${ExecParam} -fourthip ${fourthip}`
    fi

    if [ "X${fifthip}" != "X" ];then
        ExecParam=`echo ${ExecParam} -fifthip ${fifthip}`
    fi

    if [ "X${accessnic}" != "X" ];then
        ExecParam=`echo ${ExecParam} -accessnic ${accessnic}`
    fi

    if [ "X${accessnic2}" != "X" ];then
        ExecParam=`echo ${ExecParam} -accessnic2 ${accessnic2}`
    fi

    if [ "X${accessnetmask}" != "X" ];then
        ExecParam=`echo ${ExecParam} -accessnetmask ${accessnetmask}`
    fi

    if [ "X${accessnetmask2}" != "X" ];then
        ExecParam=`echo ${ExecParam} -accessnetmask2 ${accessnetmask2}`
    fi

    if [ "X${mode}" != "X" ];then
        ExecParam=`echo ${ExecParam} -mode ${mode}`
    fi

    if [ "X${azname}" != "X" ];then
        ExecParam=`echo ${ExecParam} -azname ${azname}`
    fi

    if [ "X${scalesize}" != "X" ];then
        ExecParam=`echo ${ExecParam} -scalesize ${scalesize}`
    fi

    if [ "X${networkinfo}" != "X" ];then
        ExecParam=`echo ${ExecParam} -networkinfo ${networkinfo}`
    fi

    if [ "X${ommhaheartip}" != "X" ];then
        ExecParam=`echo ${ExecParam} -ommhaheartip ${ommhaheartip}`
    fi

    if [ "X${DR_HA_OPEN}" != "X" ];then
        ExecParam=$(echo ${ExecParam} -DR_HA_OPEN ${DR_HA_OPEN})
    fi

    if [ "X${DR_VIP_OPEN}" != "X" ];then
        ExecParam=$(echo ${ExecParam} -DR_VIP_OPEN ${DR_VIP_OPEN})
    fi

    if [ "X${DEPLOY_MODE}" != "X" ];then
        ExecParam=$(echo ${ExecParam} -DEPLOY_MODE ${DEPLOY_MODE})
    fi

    if [ "X${APP_ARBI_ON}" != "X" ];then
        ExecParam=$(echo ${ExecParam} -APP_ARBI_ON ${APP_ARBI_ON})
    fi

    if [ "X${pkglist}" != "X" ]
    then
        ExecParam=$(echo ${ExecParam} -pkglist ${pkglist})
    else
        ExecParam=$(echo ${ExecParam} -pkglist pkglist_default.conf)
    fi

    if [ "X${deployexpired}" != "X" ]
    then
        ExecParam=$(echo ${ExecParam} -deployexpired ${deployexpired})
    else
        ExecParam=$(echo ${ExecParam} -deployexpired 30)
    fi

    if [ "X${extpkg}" != "X" ]
    then
        ExecParam=$(echo ${ExecParam} -extpkg ${extpkg})
    fi

    if [ "X${commonCertExtendedKeyUsage}" != "X" ]
    then
        ExecParam=$(echo ${ExecParam} -commonCertExtendedKeyUsage ${commonCertExtendedKeyUsage})
    fi

    # 获取密码
    get_install_pw

    #获取交互信息
    getInput

    return 0
}

create_pwuser()
{
    (echo $all_os_default_passwd; echo $product_pwd_sopuser; echo $product_pwd_ossadm; echo $product_pwd_ossuser; echo $product_pwd_redis_dbuser; echo $product_pwd_zenith_sys; echo $product_pwd_admin_web_control;) | bash ${installDir}/create_pwfile.sh ${installDir} $uniepPkg_path
}

#初始化包
checkPackage()
{
    #==========================管理包===============================
    #检查包
    uniepPkg=`ls $installDir | grep "^${uniepPackage}$" | grep -v grep`
    if [ "$uniepPkg" = "" ]
    then
        OperateLog "error" "Error: the uniep package is not exists, rendering the install_uniep.sh script failed."
        return 1
    fi

    chmod -R 750 $installDir > /dev/null 2>&1
    cd $installDir

    if [ -d $installDir/${uniepPkg%%.*} ];then
        rm -rf $installDir/${uniepPkg%%.*}
    fi
    uniepPkg_path=$installDir/${uniepPkg%%.*}
    unzip -oq $uniepPkg -d  $uniepPkg_path
    return 0
}

Remote_uninstall()
{
    expect <<END
        spawn ssh root@${1} "su - ossadm -c 'cd /opt/oss/manager/agent/tools/shscript && bash uninstall.sh -f'"
        expect {
        "*yes/no*" {send "yes\r";exp_continue}
        "*assword:" {send "${2}\r"}
        }
        set timeout 300
        expect eof
END
}

uninstall()
{
    OperateLog "info" "start exec install_manager.sh uninstall."
    #多OMP场景卸载备OMP节点
    echo "${ExecParam}" | grep 'standbyip' >/dev/null 2>&1
    if [ $? -eq 0 ];then
        if [ "X${standbyip}" != "X" ];then
            Remote_uninstall ${standbyip} ${node_2_root_pwd} >>$logFile 2>&1
        fi
        if [ "X${thirdip}" != "X" ];then
            Remote_uninstall ${thirdip} ${node_3_root_pwd} >>$logFile 2>&1
        fi
    fi

    #卸载管理面
    if [ -f "/opt/oss/manager/agent/tools/shscript/uninstall.sh" ]
    then
        cd /opt/oss/manager/agent/tools/shscript && bash uninstall.sh -f >>$logFile 2>&1
    else
        OperateLog "WARN" "/opt/oss/manager/agent/tools/shscript/uninstall.sh is not exists."
    fi
}

update_crl()
{
    crl_file_build="/opt/install/HuaweiRootCAsipCRLs.crl"
    crl_file_release="/opt/install/HuaweiRootCAsipCRLs_Release.crl"
    if [ ! -d "/tmp/oss" ]
    then
        mkdir "/tmp/oss"
        chown ossadm:ossgroup "/tmp/oss"
    fi

    if [ -f ${crl_file_release} ]
    then
        cp ${crl_file_release} "/tmp/oss"
        chmod 400 "/tmp/oss/HuaweiRootCAsipCRLs_Release.crl"
        chown ossadm:ossgroup "/tmp/oss/HuaweiRootCAsipCRLs_Release.crl"
        curPath="/opt/oss/manager/apps/UniEPService/tools/crlTools"
        excute_ord="huaweicrltool.sh -cmd replaceCrl -all -type RELEASE_SIGN"
        su - ossadm -c "cd ${curPath} && echo 'y' | bash ${excute_ord}"
        RESULT=$?
        if [ ${RESULT} -ne 0 ]
        then
            OperateLog "error" "Error:update release crl failed"
        else
            OperateLog "info" "update release crl successfully"
        fi
    fi

    if [ -f ${crl_file_build} ]
    then
        cp ${crl_file_build} "/tmp/oss"
        chmod 400 "/tmp/oss/HuaweiRootCAsipCRLs.crl"
        chown ossadm:ossgroup "/tmp/oss/HuaweiRootCAsipCRLs.crl"
        if [ -f "/tmp/oss/HuaweiRootCAsipCRLs_Release.crl" ]
        then
            mv /tmp/oss/HuaweiRootCAsipCRLs_Release.crl /tmp/oss/cs_g2_crls.crl
        fi
        curPath="/opt/oss/manager/apps/UniEPService/tools/crlTools"
        excute_ord="huaweicrltool.sh -cmd replaceCrl -all -type BUILD_SIGN"
        su - ossadm -c "cd ${curPath} && echo 'y' | bash ${excute_ord}"
        RESULT=$?
        if [ ${RESULT} -ne 0 ]
        then
            OperateLog "error" "Error:update build crl failed"
        else
            OperateLog "info" "update build crl successfully"
        fi
    fi
}

deal_empty_nodes()
{
    if [ "X${drnetworktype}" != "X" ];then
        bash ${curPath}/deal_empty_nodes.sh ${installDir} ${drnetworktype}
        return 0
    fi
    bash ${curPath}/deal_empty_nodes.sh ${installDir} "IPv4"
}

#installUniep
Install()
{
    uninstall
    checkPackage
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Failed to check the package, rendering the install_uniep.sh script failed."
        return 1
    fi

    create_pwuser
    deal_empty_nodes
    #========================安装管理面=================================

    chmod -R 750 $installDir > /dev/null 2>&1

    cd $installDir/${uniepPkg%%.*}


    #调用平台执行安装管理面
    echo "bash install.sh $ExecParam -pwfile ${installDir}/pwuser.json"
    bash install.sh ${ExecParam} -pwfile "${installDir}"/pwuser.json
    res=$?

    # 一定要删除密码文件
    rm -rf "${installDir}"/pwuser.json

    chmod 640 logs/bootstrap.log > /dev/null 2>&1
    chmod 640 logs/addmgmtnic.log > /dev/null 2>&1
    if [ $res -eq 0 ]
    then
        echo "#!/bin/bash
echo  RESULT:100 && rm -rf /opt/install/check_manager_result.sh
   ">/opt/install/check_manager_result.sh
        OperateLog "info" "Management plane installed successfully."
        #管理面安装成功了以后,调取平台命令替换签名文件
        update_crl
        if [ "X${version}" != "X" ];then
            bash change_version.sh ${version}
            if [ $? -ne 0 ]
            then
                OperateLog "error" "Error: Change OMP version failed."
            fi
        fi
    else
        echo "#!/bin/bash
echo  RESULT:255 && rm -rf /opt/install/check_manager_result.sh
   ">/opt/install/check_manager_result.sh
        OperateLog "error" "Error: Failed to install management plane, rendering the install_uniep.sh script failed."
    fi
    chmod 750 /opt/install/check_manager_result.sh > /dev/null 2>&1
    exit $res
}

Main()
{
    createCheckFile
    #get all install parameter
    CheckInstallPara $*
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Input parameters are incorrect, rendering the install.sh script failed."
        return 1
    fi
    GetUniepPackageName

    #将脚本耗时操作后台挂起执行，防止EasySuite断开导致安装失败
    Install
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Failed to init the software package, rendering the install_uniep.sh script failed."
        return 1
    fi

    return 0
}

id | grep "ossadm" &>/dev/null
if [ $? -eq 0 ]
then
    Main $*
    getcheckResult $?
    RESULT=$?
else
    chmod -R 750 ${curPath}
    chown -R ossadm:ossgroup ${curPath}
    su - ossadm -c "cd ${curPath} && bash ${MODULE_NAME} $*"
    RESULT=$?
fi

if [ ${RESULT} -eq 0 ]
then
    logger -t ${USER} -p local0.info "${MODULE_NAME}; INFO: Succeeded to install manager."
else
    logger -t ${USER} -p local0.err "${MODULE_NAME}; Error: Failed to install manager."
fi
exit ${RESULT}
