#!/bin/bash
. /etc/profile
USER=$(whoami)
MODULE_NAME="$(basename $0)"
# modify nodethreshold file name
MODIFY_THRESHOLD_FILE="modify_nodethreshold.pyc"
#install dir
installDir=/opt/install

createCheckFile()
{

    echo "#!/bin/bash
echo  RESULT:1
   ">${installDir}/check_product_result.sh

   chmod 750 ${installDir}/check_product_result.sh
}

#getWorkPath
GetWorkPath()
{
    dir=`dirname $0`
    ispointstart=`echo $dir|awk -F/ '{print $1}'`
    if [ "$ispointstart" = "." ]
    then
        dir=`echo $dir|sed 's/^.//'`
        curPath="`pwd`$dir"
    elif [ "$ispointstart" = ".." ]
    then
        curPath="`pwd`/$dir"
    else
        curPath="$dir"
    fi
    return 0
}
GetWorkPath

getcheckResult()
{
   if [ $1 -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf ${installDir}/check_product_result.sh
   ">${installDir}/check_product_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf ${installDir}/check_product_result.sh
   ">${installDir}/check_product_result.sh
   fi
   chmod 750 ${installDir}/check_product_result.sh > /dev/null 2>&1
}

logFile="${curPath}/${MODULE_NAME}.log"

#log
OperateLog()
{
    BASH_PID=$$
    if [ ! -f ${logFile} ]
    then
        touch ${logFile}
        chmod 640 ${logFile}
        chown ossadm:ossgroup ${logFile}
    fi

    echo $1 | grep -i "ERROR" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="ERROR"
    fi
    echo $1 | grep -i "WARN" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="WARN"
    fi
    if [ -z "${Level}" ]
    then
        Level="INFO"
    fi

    echo "[$(date '+%Y-%m-%d %H:%M:%S')] [${BASH_PID}] | ${Level} $2" | tee -a ${logFile}
}

getInstallParam()
{
  ARGS=`getopt -a -o p:i:n: -l path:,input_name:,product_name:, -- "$@"`
  eval set -- "${ARGS}"
  while true
  do
   case $1 in
   -p|--path)
     OperateLog "info" "path:$2";installDir=$2
     ;;
   -i|--input_name)
     OperateLog "info" "input_name:$2";input_name=$2
     ;;
   -n|--product_name)
     OperateLog "info" "product_name:$2";product_name=$2
     ;;
   --)
     shift
     break
     ;;
   esac
  shift
  done

  if [ "X${input_name}" != "X" ]; then
    input_path=${installDir}/${input_name}.json
  elif [ "X${product_name}" != "X" ]; then
    input_path=${installDir}/input_${product_name}.json
  else
    input_path=${installDir}/input.json
  fi
  OperateLog "info" "input_path:$input_path"
}

#install product
Install()
{

  # 如果已经调用，执行重试脚本
    pyscript="/opt/install/install_retry.py"
    if [ ! -f "${pyscript}" ]
    then
        pyscript="/opt/install/install_retry.pyc"

    fi
    chown ossadm:ossgroup ${pyscript}
    . /opt/oss/manager/bin/engr_profile.sh
    python ${pyscript} ${input_path}
    retry_code=$?
    # 返回100没有查到失败记录就重新创建任务
    if [ $retry_code -eq 100 ]
    then
        cd /opt/oss/manager/tools/deployapp && unbuffer bash installproduct.sh -input ${input_path}
        install_code=$?
        if [ $install_code -ne 0 ]
        then
            echo "Error: Failed to execute installproduct.sh."
            return install_code
        fi
        return 0
        logger -p local0.info "install_product.sh:success to install product"
    fi
    if [ $retry_code -eq 0 ]
    then
        echo "Success: success to i product."
        return 0
        logger -p local0.info "install_product.sh:success to install product"
    fi

    echo "Error: Query the deploy history, the product is failed."
    return 1
}

# set modify alarm threshold file
set_file()
{
    if [ -f "${curPath}/modify_nodethreshold.pyc" ]
    then
        MODIFY_THRESHOLD_FILE="modify_nodethreshold.pyc"
    else
        if [ -f "${curPath}/modify_nodethreshold.py" ]
        then
            MODIFY_THRESHOLD_FILE="modify_nodethreshold.py"
        else
            OperateLog "Warning" "Warning: Can not find modify nodethreshold file"
            return 1
        fi
    fi
    chown ossadm: "${curPath}"/modify_nodethreshold.py*
}

# Modify the alarm threshold.
ModifyAlarmThreshold()
{
    OperateLog "info" "Info:Start Modify the alarm threshold."
    local query_temp="${curPath}"/queryproduct_temp
    [ -n "${curPath}" ] && rm -rf "${query_temp}"
    [ ! -d "${query_temp}" ] && mkdir -p "${query_temp}"
    chown ossadm: "${query_temp}"
    chmod 770 "${query_temp}"
    [ -f /opt/oss/manager/tools/resmgr/queryproduct.sh ] && bash /opt/oss/manager/tools/resmgr/queryproduct.sh -pn all -output "${query_temp}"
    local product_all_name=($(cat "${query_temp}"/product_*.json | sed -e 's/,/\n/g' | sed -e 's/}/\n/g' | grep "productname" | awk -F ":" '{print $2}' | awk -F '"' '{print $2}'))
    OperateLog "info" "Info:Get all product name: ${product_all_name[@]}."
    local product_length="${#product_all_name[@]}"
    local count=0
    . /opt/oss/manager/bin/engr_profile.sh
    cd "${OSS_ROOT}"/apps/DeployAgent/bin
    for product_name in ${product_all_name[@]}
    do
    {
        OperateLog "info" "Info:Get Threshold json with product: ${product_name}."
        threshold_json=$(./ipmc_tool -cmd monitor -o getNodeThreshold -product "${product_name}")
        if [ $? -eq 0 ]
        then
            json_path=$(echo ${threshold_json} | awk -F': ' '{print $2}')
            OperateLog "info" "Info:Get nodethreshold.json: ${json_path}."
            . /opt/oss/manager/bin/engr_profile.sh
            python "${curPath}/${MODIFY_THRESHOLD_FILE}" "${json_path}"
            if [ $? -eq 0 ]
            then
                OperateLog "info" "Info:Succeed to execute the modify_nodethreshold.py."
                cp -rvf "${json_path}" "${curPath}"
                ./ipmc_tool -cmd monitor -o setNodeThreshold -product "${product_name}" -filePath "${json_path}"
                if [ $? -eq 0 ]
                then
                    OperateLog "info" "Info:Succeed to execute the ipmc_tool command modify nodethreshold of product: ${product_name}."
                    let count++
                else
                    OperateLog "Warning" "Warning:Failed to execute the ipmc_tool command modify nodethreshold of product: ${product_name}."
                fi
            else
                OperateLog "Warning" "Warning:Failed to execute the ${MODIFY_THRESHOLD_FILE} modify nodethreshold of product: ${product_name}."
            fi
        else
            OperateLog "Warning" "Warning:Failed to execute the command: ./ipmc_tool -cmd monitor -o getNodeThreshold -product ${product_name}."
        fi
    }
    done
    if [ "${product_length}" -eq "${count}" ]
    then
        return 0
    else
        return 1
    fi
}

Main()
{
    createCheckFile
    getInstallParam $*
    #install
    Install
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Failed to init the software package, rendering the install_uniep.sh script failed."
        return 1
    fi
    # Modify the alarm threshold.
    set_file
    local retry_count=0
    while true
    do
    {
        ModifyAlarmThreshold
        if [ $? -eq 0 ]
        then
            OperateLog "info" "Info: Succeed to Modify the alarm threshold."
            break
        else
            OperateLog "info" "Info: Failed to Modify the alarm threshold, retry after 60s."
            sleep 60
            let retry_count++
            if [ ${retry_count} -eq 10 ]
            then
                OperateLog "Warning" "Warning: Failed to Modify the alarm threshold."
                break
            fi
        fi
    }
    done
    return 0
}

id | grep "ossadm" &>/dev/null
if [ $? -eq 0 ]
then
    Main $*
    getcheckResult $?
    RESULT=$?
else
    chmod -R 750 ${curPath}
    chown -R ossadm:ossgroup ${curPath}
    su - ossadm -c "cd ${curPath} && bash ${MODULE_NAME} $*"
    RESULT=$?
fi

if [ ${RESULT} -eq 0 ]
then
    logger -t ${USER} -p local0.info "${MODULE_NAME}; INFO: Succeeded to install product."
else
    logger -t ${USER} -p local0.err "${MODULE_NAME}; Error: Failed to install product."
fi
exit ${RESULT}
