#!/bin/bash
. ./controller.inc
if [ `echo $0 | grep -c "/"` -gt 0 ];then
    cd ${0%/*}     
fi

################################################################################
# Function    : check_os_hostname
# Description : check the os hostname.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_os_hostname
{  
    host=`hostname`
    file="/etc/hosts"

    nodes=`cat /etc/hosts | grep "$host"`
    if [ $? -ne 0 ]
    then  
        print_log "ERROR" "There is no expected hostname in /etc/hosts, please add it."
        print_log "ERROR" "The value of /etc/hosts must be the same as the /etc/hostname,The values of /etc/hostname for each node are different."
        return 1
    fi
	
    hostname=`echo ${host} | sed 's/_/-/g'`	
    print_log "INFO" "Hostname input is ${hostname}, hostname of the node is ${host}."	
    if [ "X${hostname}" == "X" ];then
        print_log "WARNING" "Hostname to be checked is not configured,skip check hostname."
        return 0
    fi
    STANDARD="(^[a-zA-Z][a-zA-Z0-9-]*[a-zA-Z0-9]$)|(^[a-zA-Z]$)"
    if [[ ${hostname} =~ $STANDARD ]];then
	    print_log "INFO" "The hostname is standardized."
    else
	    print_log "ERROR" "The hostname is not standardized."
        return 1
    fi
    
    if [ "X${hostname}" != "X${host}" ];then
	    print_log "ERROR" "Hostname check failed."
        return 1
    fi
    print_log "INFO" "Hostname check successfully."
    return 0
}

