#!/bin/bash
. /etc/profile


waitIOHealth()
{
    for ((i=0; i<12; i++))
    do
        [ ! -f iostat ] && { return 0; }
        #wait all io util < 85
        isok=`iostat -d -x 1 2 | sed -n '/Device:/,$p' | sed '/Device:/d' | sed '/^$/d'  | awk '{print $NF}'  | awk '{print $NF}'  | awk 'BEGIN {isok = 0}
        {
            for (j = 1; j <= NF; ++j) {
                if ($j > 85) isok = 1
            }
        }
        END {print isok}'`
        [ "$isok" == 0 ] && { echo "io stat is ok"; break; }
        echo "io util is more than 85%, sleep 10 seconds..."
        sleep 10
    done
}

#getWorkPath
GetWorkPath()
{
    dir=`dirname $0`
    ispointstart=`echo $dir|awk -F/ '{print $1}'`
    if [ "$ispointstart" = "." ]
    then
        dir=`echo $dir|sed 's/^.//'`
        curPath="`pwd`$dir"
    elif [ "$ispointstart" = ".." ]
    then
        curPath="`pwd`/$dir"
    else
        curPath="$dir"
    fi
    return 0
}

logFile="${curPath}/expansion_scan_pkg.log"

#check root user
CheckUser()
{
    USER_ID=`id -u`
    if [ $USER_ID -ne 0 ]
    then
        echo "Run the script as the root user."
        return 1
    fi

    return 0
}


#log
OperateLog()
{
    BASH_PID=$$
    if [ ! -f ${logFile} ]
    then
        touch ${logFile}
        chmod 660 ${logFile}
        chown ossadm:ossgroup ${logFile}
    fi
    Level="INFO"
    echo $1 | grep -i "ERROR" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="ERROR"
    fi
    echo $1 | grep -i "WARN" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="WARN"
    fi
    echo $1 | grep -i "INFO" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="INFO"
    fi

    echo "[$(date '+%Y-%m-%d %H:%M:%S')] [${BASH_PID}] | ${Level} $2" | tee -a ${logFile}
}


ScanPackage()
{
    # chmod -R 750 $curPath > /dev/null 2>&1

    rm -rf /opt/oss/manager/var/tmp/*
    rm -rf /opt/pub/software/services/*

    for package in $*
        do
        {
            echo ${curPath}/${package}
            cp -rf ${curPath}/${package} /opt/oss/manager/var/tmp
            if [ $? -ne 0 ]
            then
              return 1
            fi
            # 如果是p7s签名，复制对应签名文件
            if [ -f "${curPath}/${package}.p7s" ]
            then
                cp -rf ${curPath}/${package}.p7s /opt/oss/manager/var/tmp
            else
                cp -rf ${curPath}/${package}.cms /opt/oss/manager/var/tmp
                cp -rf ${curPath}/${package}.crl /opt/oss/manager/var/tmp
            fi
        }
    done
    # 要根据实际/opt/oss/manager/var/tmp权限复制
    chown -R ossadm: /opt/oss/manager/var/tmp


    waitIOHealth

    #scan silent
    su - ossadm -c "cd /opt/oss/manager/tools/deployapp && bash scanpackage.sh"
    if [ $? -ne 0 ]
    then
        OperateLog "Error" "scan package failed"
        return 1
    fi

    return 0
}

Main()
{
    GetWorkPath
    # 防呆，结果文件
    if [ ! -f "${curPath}/expansion_scan_pkg_flag.log" ]
    then
        touch "${curPath}/expansion_scan_pkg_flag.log"
    fi
    CheckUser
    if [ $? -ne 0 ]
    then
        OperateLog "Error" "Failed to check the logged-in user"
        return 1
    fi
    ScanPackage $*
    if [ $? -ne 0 ]
    then
        OperateLog "Error" "Failed to init the software package"
        return 1
    fi
    
   return 0
}

Main $*
echo $? > "${curPath}/expansion_scan_pkg_flag.log"
exit $?