#!/bin/bash
#####################################################################################
#
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
#
# Description: FC8.3.0安装VRM，连接VRM失败，则去解锁高斯数据库账号，重启服务后重试
#
# Usage： bash unlock_fc_db_user.sh
#
# Output: 执行结果
#
#####################################################################################
# 超时时间
TIMEOUT=20
# 成功退出
RETURN_SUCCESS_CODE=0
# 超时退出
RETURN_TIMEOUT=201
# 日志文件
LOG_FILE=/var/log/unlock_fc_db_user.log

echo "es_input: POSTGRES_USER_PWD"
read -sr POSTGRES_USER_PWD
POSTGRES_USER_PWD=$(echo ${POSTGRES_USER_PWD} | sed 's/\\/\\\\/g' | sed 's/}/\\}/g' | sed 's/{/\\{/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')


##################################################
# 日志记录
##################################################
function logger() {
    local current_time=`date "+%Y-%m-%d %H:%M:%S"`
    echo "[$current_time] $*" >> "$LOG_FILE"
}


##################################################
# expect命令解锁数据库用户命令
##################################################
function exec_unlock_cmd() {
    expect_output=$(expect << ENF
    set timeout ${TIMEOUT}
    spawn psql -U postgres
    expect {
        "*assword" { send -- "${POSTGRES_USER_PWD}\r" }
    }
    expect {
        "*=#" { send "alter user galax account unlock;\r" }
    }
    expect {
        "*=#" { exit ${RETURN_SUCCESS_CODE} }
    }
    expect timeout { exit ${RETURN_TIMEOUT} }
    expect eof
ENF
)
    return_code=$?
    logger "exec unlock cmd return code is ${return_code}, output is ${expect_output}"
    return ${return_code}
}


##################################################
# 重启相关服务
##################################################
function restart_app() {
    local array=("cepd" "kmsd" "analyzerd" "fmcd" "pmcd" "notifyd" "vrmd")
    for((i=0;i<${#array[@]};i++));do
        logger "start to restart app: ${array[i]}"
        service ${array[i]} restart >> ${LOG_FILE} 2>&1
    done
}


##################################################
# 确认服务状态是否正常
##################################################
function query_app_status() {
    sleep 120
    count=0
    while true; do
        service vrmd status | grep "Active: active" | grep "running"
        [ $? -eq 0 ] && { logger "app status is normal"; return 0; }
        sleep 10
        let count++
        # 3分钟检查结果异常，则返回退出
        [ ${count} -eq 18 ] && { logger "Failed to query app status."; return 1; }
    done
}


##################################################
# 主方法
##################################################
function main() {
    logger "start to exec unlock fc db user shell script"
    exec_unlock_cmd || return $?
    logger "start to restart app"
    restart_app || return $?
    logger "start to check app status"
    query_app_status
    return $?
}

main "$@"
exit $?
