#!/bin/bash
# Copyright Huawei Technologies Co., Ltd. 2020-2021. All rights reserved.

service_IP=$1
service=$2

function main()
{
    # check service
    local check_app="cd /opt/oss/manager/agent/bin/; ./ipmc_adm -cmd statusapp -app ${service}"
    local check_result=$(ssh ossadm@${service_IP} -o stricthostkeychecking=no ${check_app} | grep "All Processes:")
    if [ "${check_result}" ]
    then
        echo "${service_IP} matched ${service} processes or service successfully."
        exit 0
    else
        echo "${service_IP} matched ${service} processes or service failed."
        exit 1
    fi
}

main $@
exit $?