#!/bin/bash
# Copyright Huawei Technologies Co., Ltd. 2020-2021. All rights reserved.

check_IP="$1"
service_IP="$2"
port="$3"
protocol="$4"

# 上传端口检测文件至业务节点
function upload_file()
{
    local src_file="$1"
    local dst_file="$2"
    if [ ! -f "${src_file}" ]
    then
        echo "Failed to upload the ${src_file} file to the target node because the file does not exist."
        return 1
    fi
    expect <<END &>/dev/null
       spawn scp -p ${src_file} ossadm@\[${service_IP}\]:${dst_file}
       expect {
       "*yes/no*" {send "yes\r";exp_continue}
       "*assword:" {send "${INTPUT_NODE_PWD}\r"}
}
       set timeout 30
       expect eof
END
    echo "The script ${dst_file} is uploaded successfully."
    return 0
}

function main()
{
    local src_dir=$(dirname $(readlink -f "$0"))
    local tmp_path=/home/ossadm/test_port_tmp
    [ ! -d "${tmp_path}" ] && mkdir -p "${tmp_path}"
    local test_result="${tmp_path}"/test_"${service_IP}"_"${check_IP}"_"${port}"_"${protocol}".log
    local time_stamp=$(date +"%Y%m%d%H%M%S")
    local exec_cmd_2="bash /home/ossadm/check_port_connect.sh $@ ${tmp_path}"
    local check_res="cat ${test_result}"
    # Checked or Not before
    ssh ossadm@${service_IP} -o stricthostkeychecking=no "${check_res}" | grep "connect_result" &>/dev/null
    if [ $? -eq 0 ]
    then
        echo "${service_IP} has upload file before"
    else
        echo "New check : upload ${src_dir}/check_port_connect.sh to ${service_IP}:/home/ossadm/"
        scp -o stricthostkeychecking=no -p "${src_dir}/check_port_connect.sh" ossadm@\[${service_IP}\]:"/home/ossadm/check_port_connect.sh"
        
        if [ $? -ne 0 ]
        then
            echo "upload ${src_dir}/check_port_connect.sh to ${service_IP}:/home/ossadm/ failed!"
            exit 1
        fi
    fi
    local cmd="${exec_cmd_2};${check_res}"
    local result=$(ssh ossadm@${service_IP} -o stricthostkeychecking=no "${cmd}")
    echo "${result}" | grep "connect_result=0" &>/dev/null
    if [ $? -eq 0 ]
    then
        echo "${time_stamp} Test from ${service_IP} to NE(${check_IP}:${port}) successfully!" >> ${src_dir}/portcheck.log
        exit 0
    else
        echo "${result}" | grep "connect_result=1" &>/dev/null
        if [ $? -eq 0 ]
        then
            echo "${time_stamp} Test from ${service_IP} to NE(${check_IP}:${port}) failed!" >> ${src_dir}/portcheck.log
            exit 1
        else
            echo "${time_stamp} ${service_IP} connect to ${check_IP} failed!" >> ${src_dir}/portcheck.log
            exit 2
        fi
    fi


}

main $@
exit $?