#!/bin/bash

function main
{
    local LANG=$1
    local str_format="UTF-8"
    local lang_str="${LANG}.${str_format}"
    local lang=`cat /etc/profile | grep "^LANG="`
    local lc_all=`cat /etc/profile | grep "^LC_ALL="`
    local export_lang=`cat /etc/profile | grep -w "export LANG"`
    local export_lc=`cat /etc/profile | grep -w "export LC_ALL"`
    if [[ "${lang}X" == "X" ]]
    then
        echo "LANG=${lang_str}" >> /etc/profile
    else
        sed -i "s/LANG=.*/LANG=${lang_str}/g" /etc/profile
    fi
    if [[ "${lc_all}X" == "X" ]]
    then
        echo "LC_ALL=${lang_str}" >> /etc/profile
    else
        sed -i "s/LC_ALL=.*/LC_ALL=${lang_str}/g" /etc/profile
    fi
    if [[ "${export_lang}X" == "X" ]]
    then
        echo "export LANG" >> /etc/profile
    fi
    if [[ "${export_lc}X" == "X" ]]
    then
        echo "export LC_ALL" >> /etc/profile
    fi

    sed -i '/LANG/g' /root/.bash_profile 2>/dev/null
    sed -i '/LC_ALL/g' /root/.bash_profile 2>/dev/null
    source /etc/profile
    echo "Set os language successful." >&1
}

main $@