#!/bin/bash

function main
{
    local ZONE_INFO=$1
    local TIME_ZONE=`echo ${ZONE_INFO##*)}`
    local ZONE_INFO_PATH="/usr/share/zoneinfo"

    rm -f "/etc/localtime"
    ln -sf "${ZONE_INFO_PATH}/${TIME_ZONE}" "/etc/localtime" > /tmp/set_timezone.log 2>&1
    if [[ $? != 0 ]]
    then
        echo "Set timezone failed." >&2
        return 1
    fi
    echo "Set timezone successful." >&1
}

main $@