#!/bin/sh

#
vgname="vg_ossdata"
#߼
lvname="lv_ossdata"
#ҽӵ
lvmdir="/opt/ossdata"
#ϵͳҽļ
mountfile="/etc/fstab"

#log
OperateLog()
{
    if [ -f "$curPath/../OperationLog/businessoperatelog.sh" ]
    then
        sh $curPath/../OperationLog/businessoperatelog.sh "$1" "$2"
        return 0
    fi
}

#ȡдб
GetFreeDiskList()
{
    ret=""
    #
    for disk in `lsscsi | grep "/dev/sd" | grep -v "/dev/sda "| awk '{print $7}'`
    do
        parted -s $disk print 2>/dev/null | grep -i "lvm" >/dev/null 2>&1
        if [ $? -ne 0 ]
        then
            if [ "x$ret" = "x" ]
            then
                ret="$disk"
            else
                ret="$ret\n$disk"
            fi
        fi
    done
    echo -e $ret
}

#
CreatePartition()
{
    parted -s $1 mklabel gpt
    parted -s $1 -- mkpart primary 0 -1 >/dev/null 2>&1
    parted -s $1 set 1 lvm on
    
    #ˢ·
    partprobe >/dev/null 2>&1
}

#ȡʣռ
GetVGSize()
{
    #Free  PE / Size       113920 / 445.00 GiB
    vgsize=`vgdisplay 2>/dev/null $1 | grep "Free *PE */ *Size" | awk -F"/" '{print $2}' | awk '{print $2}'`
    echo $vgsize
}

#lv_ossdata
CreateLV()
{
    df -h|grep "/opt/ossdata" >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        echo "Failed, The OS data partition exist, can not add again."
        OperateLog "Execute addgpdisk.sh failed, The OS data partition exist, can not add again." "error"
        return 1
    fi
    #ȡҽӲ
    freedisks=`GetFreeDiskList`
    freediskscount=`echo "$freedisks" | wc -l`
    if [ $freediskscount -ne 6 ]
    then
        echo "Failed, The free disks is not equal 6, can not process."
        OperateLog "Execute addgpdisk.sh failed, The free disks is not equal 6, can not process." "error"
        return 1
    fi
    i=1
    for disk in $freedisks
    do
        #LVM(ֻһ:${disk}1)
        CreatePartition "$disk"
        #¾
        vgcreate $vgname${i} "${disk}1"
        #ȡVGʣС
        vgfreesize=`GetVGSize $vgname${i}`
        lvcreate -l $vgfreesize -n $lvname${i} $vgname${i}
        mkfs.xfs /dev/$vgname${i}/$lvname${i}
        mkdir -p /opt/ossdata/data${i}
        mount -o nodev,noatime,nobarrier,inode64 /dev/$vgname${i}/$lvname${i} /opt/ossdata/data${i}
        tmpdisk=`echo ${disk/dev/block}`
        echo deadline > /sys/$tmpdisk/queue/scheduler
        #עҽ
        cat ${mountfile} | grep "/opt/ossdata/data${i}" > /dev/null 2>&1
        if [ $? -ne 0 ]
        then
            echo -e "/dev/$vgname${i}/$lvname${i}\t/opt/ossdata/data$i\txfs\tnodev,noatime,nobarrier,inode64\t0 0" >> ${mountfile}
        fi
        i=`echo $i+1|bc`
    done
    chown -Rh dbuser:ossgroup /opt/ossdata/data* > /dev/null 2>&1
    echo GRUB_CMDLINE_LINUX="elevator=deadline" >> /etc/default/grub
    grub2-mkconfig -o /boot/grub2/grub.cfg
    return 0
}

Main()
{
    OperateLog "Execute addgpdisk.sh begin." "information"
    
    #
    CreateLV
    if [ $? -ne 0 ]
    then
        OperateLog "Execute addgpdisk.sh failed." "error"
        exit 1
    fi
    
    OperateLog "Execute addgpdisk.sh successful." "information"
    
    exit 0
}

Main

