#!/bin/bash
node_ip=$1
coredump="/opt/oss/log/NCE/coredump"

# 检查coredump目录权限
ssh ${node_ip} -o stricthostkeychecking=no "stat -L -c '%a' ${coredump} | grep '770'" &>/dev/null
[ $? -eq 0 ] && exit 0

# 异常情况创建coredump目录,并修改权限
ssh ${node_ip} -o stricthostkeychecking=no "[ ! -d ${coredump} ] && mkdir -p ${coredump}; chmod 770 ${coredump}" &>/dev/null
[ $? -ne 0 ] && exit 1

# 异常情况处理后检查
ssh ${node_ip} -o stricthostkeychecking=no "stat -L -c '%a' ${coredump} | grep '770'" &>/dev/null
exit $?