#!/bin/bash
#########################################
# 功能描述：通过OMP节点查询产品信息
#########################################
function query_product_info()
{
    query_product_path="/opt/oss/manager/tools/resmgr/queryproduct.sh"
    if [ ! -x $query_product_path ];then
        echo "Query product infomation failure, because this ip is not omp!"
        exit 1
    fi
    bash /opt/oss/manager/tools/resmgr/queryproduct.sh  -pn NCE -output /home/ossadm/org_product_info
    if [ ! -f "/home/ossadm/org_product_info/product_NCE.json" ];then
        echo "Error: Failed to query product info."
        exit 1
    fi
    
    if [ -f "/opt/expansion/query_package.pyc" ]
    then
        QUERY_PACKAGE=query_package.pyc
    else
        if [ -f "/opt/expansion/query_package.py" ]
        then
            QUERY_PACKAGE=query_package.py
        fi
    fi

    . /opt/oss/manager/bin/engr_profile.sh;export SSL_ROOT=/opt/oss/manager/etc/ssl;export CIPHER_ROOT=/opt/oss/manager/etc/cipher;TMOUT=0;python /opt/expansion/${QUERY_PACKAGE}
    if [ $? -ne 0 ]
    then
        echo "Error: Failed to query package."
        exit 1
    fi
}
query_product_info
exit $?
