#!/bin/bash
#create action.json check file

Main()
{
    # do create input_param
    chown ossadm:ossgroup /opt/expansion
    chown ossadm:ossgroup /opt/expansion/query_product_info.sh
    if [ -f "/opt/expansion/query_package.pyc" ]
    then
        EXPAND_FILE=query_package.pyc
    else
        if [ -f "/opt/expansion/query_package.py" ]
        then
            EXPAND_FILE=query_package.py
        else
            echo "Error: Can not find query_package file"
        fi
    fi
    chown ossadm:ossgroup /opt/expansion/${EXPAND_FILE}
    # 删除旧的
    rm -rf /home/ossadm/org_product_info
    mkdir -p /home/ossadm/org_product_info
    chown ossadm: /home/ossadm/org_product_info
    chmod -R 770 /home/ossadm/org_product_info
    su - ossadm -c "bash /opt/expansion/query_product_info.sh"
    if [ $? -ne 0 ]
    then
        echo "Error: Failed to query product info. Please check the system environment." >&2
        exit 1
    fi
    chmod -R 770 /home/ossadm/org_product_info
}

Main $*
exit $?


