#!/bin/bash
#脚本记录日志
if [ ! -d /var/ICMR ];then
    mkdir -p /var/ICMR
fi
logFile="/var/ICMR/uninstall_nce.log"
rm ${logFile} > /dev/null 2>& 1
touch ${logFile} > /dev/null 2>& 1
function LOG()
{
    if [ "$1" = "ERROR" ];then
        Level="ERROR"
    elif [ "$1" = "WARN" ];then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "`date +%Y`-`date +%m`-`date +%d` `date +%H`:`date +%M`:`date +%S`| ${Level} $2">>${logFile}
}

Main()
{
    #检查扩容节点是否已被当前环境添加
    omp_ip=$1
    if [ -z "${omp_ip}" ]
    then
         LOG "INFO" "No Management node information, skip uninstall."
        return 0
    fi
    node_num="0"
    if [ -f "/opt/oss/manager/etc/sysconf/nodelists.json" ]
    then
        node_num=`cat /opt/oss/manager/etc/sysconf/nodelists.json | grep -w "hostname" | wc -l`
    fi 
    if [ -f "/opt/oss/manager/var/agent/managerip.conf" ]
    then
        localip=`cat /opt/oss/manager/var/agent/managerip.conf | grep -w localip | awk -F '=' '{print $2}'`
        cheeck_omp_node=`cat /opt/oss/manager/var/agent/managerip.conf | grep -w managerip | grep ${omp_ip}`
        check_local_node=`cat /opt/oss/manager/var/agent/managerip.conf | grep -w managerip | grep ${localip}`
        if [ -n "${check_local_node}" -a "${node_num}" -gt "1" ];then
            LOG "INFO" "The expandion node is manager node."
            return 0
        elif [ -n "${cheeck_omp_node}" ];then
            LOG "INFO" "The expandion node has been added."
            return 0
        fi
    fi
    
    if [ -f "/opt/oss/manager/agent/tools/shscript/uninstall.sh" ]
    then
        LOG "INFO" "Start to run uninstall.sh."
        su - ossadm -c "cd /opt/oss/manager/agent/tools/shscript && bash uninstall.sh -f" >>${logFile} 2>&1
        sed -i '/^ossuser/d' /etc/security/opasswd >>${logFile} 2>&1
        rm -rf /opt/backup/smp/* >>${logFile} 2>&1
        LOG "INFO" "Finish to run uninstall.sh."
        return 0
    fi
}

Main $*
exit 0
