#!/bin/bash

#---------------------
#
# 检查大数据安装结果
#-------------------------------

if [ ! -d /opt/SwiftInstall/SwiftDeploy/var/tmp/workflow ]
then
    echo "Error : can not found FI install result path, FI install failed.">&2
    exit 1
fi
cd /opt/SwiftInstall/SwiftDeploy/var/tmp/workflow
logfile=`ls workflowprogress_* 2>/dev/null`
if [ $? -ne 0 ]
then
    echo "Error : can not found FI install result file, FI install failed.">&2
    exit 1
fi

cat $logfile | grep "deploystatus=0" > /dev/null 2>&1
if [ $? -eq 0 ]
then
    echo "FI install successfully."
    cd /opt/SwiftInstall/SwiftDeploy/bin
    sh start.sh stop > /dev/null 2>&1
    exit 0
fi

cat $logfile | grep "deploystatus=2" > /dev/null 2>&1
if [ $? -eq 0 ]
then
    echo "FI installing, please wait..."
    exit 0
else
    echo "Error : FI install failed.">&2
    exit 1
fi
