#!/bin/bash
MODULE_NAME="$(basename $0)"
installDir=/opt/install

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

logFile="${curPath}/${MODULE_NAME}.log"

#log
OperateLog()
{
    BASH_PID=$$
    if [ ! -f ${logFile} ]
    then
        touch ${logFile}
        chmod 640 ${logFile}
        chown ossadm:ossgroup ${logFile}
    fi

    echo $1 | grep -i "ERROR" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="ERROR"
    fi
    echo $1 | grep -i "WARN" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="WARN"
    fi
    if [ -z "${Level}" ]
    then
        Level="INFO"
    fi

    echo "[$(date '+%Y-%m-%d %H:%M:%S')] [${BASH_PID}] | ${Level} $2" | tee -a ${logFile}
}

CheckInstallPara()
{
    if [ $# -eq 2 ]
    then
       #ip格式校验
       echo $1 |grep "^[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}$" > /dev/null 2>&1
       if [ $? -ne 0 ]
       then
            echo "the $1 is invalid ip."
            return 1
       fi
       echo $2 |grep "^[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}$" > /dev/null 2>&1
       if [ $? -ne 0 ]
       then
            echo "the $2 is invalid ip."
            return 1
       fi
       
       #是否是OMP节点上的ip
       localIp=`ifconfig -a|grep inet|grep -v 127.0.0.1|grep -v inet6|awk '{print $2}'|tr -d "addr:" | grep "\<$1\>"`
       if [ -z "${localIp}" ]
       then
           echo "The ip $1 is not find in this node."
           return 1
       fi
       localIp1=`ifconfig -a|grep inet|grep -v 127.0.0.1|grep -v inet6|awk '{print $2}'|tr -d "addr:" | grep "\<$2\>"`
       if [ -z "${localIp1}" ]
       then
           echo "The ip $2 is not find in this node."
           return 1
       fi
   else
       #参数个数不对
       return 1
   fi
   
   return 0
}

Main()
{
    #get all install parameter
    CheckInstallPara $*
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Input parameters are incorrect, rendering the install.sh script failed."
        echo "RESULT:255"
        return 1
    fi

    NBI_IP=$1
    SBI_IP=$2
    
    NotifyServicePatch="/opt/oss/manager/var/etc/engrnotifyservice"
    [ ! -d $NotifyServicePatch ] && mkdir -p $NotifyServicePatch
    
    echo -e "NBI_IP=${NBI_IP}\nSBI_IP=${SBI_IP}" >>$NotifyServicePatch/engrnotifyservice.cfg
    
    chmod 640 $NotifyServicePatch/engrnotifyservice.cfg
    chown -R ossadm:ossgroup $NotifyServicePatch
    echo "RESULT:100"
    return 0
}

id | grep "ossadm" &>/dev/null
if [ $? -eq 0 ]
then
    Main $*
    exit $?
else
    chmod -R 750 ${curPath}
    chown -R ossadm:ossgroup ${curPath}
    su - ossadm -c "cd ${curPath} && bash ${MODULE_NAME} $*"
fi
