#!/bin/bash
MODULE_NAME="$(basename $0)"
nm_ip=$1
db_ip=$2

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "$ispointstart" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "$ispointstart" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

LOGFILE="${curPath}/${MODULE_NAME}.log"
>$LOGFILE

if [ "X${nm_ip}" == "X" ];then
    echo "[WARNING] nm_ip is empty"
    exit 1
fi

if [ "X${db_ip}" == "X" ];then
    echo "[WARNING] db_ip is empty"
    exit 1
fi

echo "`date`: start to execute create_trust" >> $LOGFILE
echo "create trust from $nm_ip to $db_ip" >> $LOGFILE

ping -c 1 -w 1 ${nm_ip} >> $LOGFILE 2>&1
if [ $? -ne 0 ];then
    echo "failed to connect to ${nm_ip}" >>$LOGFILE
    echo "[WARNING] failed to connect to ${nm_ip}"
    exit 1
fi

ping -c 1 -w 1 ${db_ip} >> $LOGFILE 2>&1
if [ $? -ne 0 ];then
    echo "failed to connect to ${db_ip}" >>$LOGFILE
    echo "[WARNING] failed to connect to ${db_ip}"
    exit 1
fi

#从NM节点获取ssh信息
#检查NM节点是否可以互信
result=`su - ossadm <<END
expect <<ENDL
    spawn ssh ossadm@${nm_ip}
    set timeout 5
    expect eof
ENDL
END`

echo "${result}" | egrep 'yes/no|*assword' >/dev/null 2>&1
if [ $? -eq 0 ];then
    echo "Unable to Login to ${nm_ip} without password." >> $LOGFILE
    echo "[ERROR] Unable to Login to ${nm_ip} without password."
    exit 1
fi

ssh_rsa_content=`su - ossadm -c "ssh ossadm@${nm_ip} \" [ ! -f ~/.ssh/id_rsa.pub ] && exit 1; cat ~/.ssh/id_rsa.pub;\"" 2>/dev/null | grep -v 'Authorized'`

if [ $? -ne 0 ];then
    echo "No id_rsa.pub found for ossadm" >> $LOGFILE
    echo "[WARNING] No id_rsa.pub found for ossadm"
    exit 1
fi

#写入互信信息到DB节点
#检查DB节点是否可以互信
result=`su - ossadm <<END
expect <<ENDL
    spawn ssh ossadm@${db_ip}
    set timeout 5
    expect eof
ENDL
END`

echo "${result}" | egrep 'yes/no|*assword' >/dev/null 2>&1
if [ $? -eq 0 ];then
    echo "Unable to Login to ${db_ip} without password." >> $LOGFILE
    echo "[ERROR] Unable to Login to ${db_ip} without password."
    exit 1
fi

su - ossadm -c "ssh ossadm@${db_ip} \" [ ! -d ~/.ssh ] && mkdir -p ~/.ssh/; echo ${ssh_rsa_content} >> ~/.ssh/authorized_keys; chmod 600 ~/.ssh/authorized_keys \"" > /dev/null 2>&1
if [ $? -ne 0 ];then
    echo "Create trust failed" >> $LOGFILE
    echo "[INFO] Create trust failed"
    exit 1
fi

`su - ossadm <<AEND
    ssh ossadm@${nm_ip} "
        expect << END
            spawn ssh ossadm@${db_ip} 2>/dev/null
            expect {
                \"*yes/no*\" {send \"yes\r\";}
            }
            set timeout 5
            expect eof
END" >/dev/null 2>&1
AEND`>/dev/null 2>&1

echo "Create trust success" >> $LOGFILE
echo "[INFO] Create trust success"
exit 0
