#!/bin/bash
# remove proxy with targetnetwork="0.0.0.0" of networkinfo_NCE.json
networkinfo_NCE_json_path=$1

cmd="import json, re;
obj = (json.load(open('${networkinfo_NCE_json_path}')));
for lvs_group in obj.get('lvs', []):
    for vip_item in lvs_group.get('vips', []):
        proxys = vip_item.get('proxy', [])
        remove_proxys = []
        
        for proxy in proxys:
            targetnetwork_set = set(proxy['targetnetwork'])
            empty_ip_set = {'0', '.', ':'}
            if (empty_ip_set | targetnetwork_set) == empty_ip_set:
                remove_proxys.append(proxy)
        [proxys.remove(proxy) for proxy in remove_proxys]

        if len(proxys) == 0 and remove_proxys:
            vip_item.pop('proxy')

ipv4_pattern=re.compile(r'[\d]+\.[\d]+\.[\d]+\.[\d]');
ipv6_pattern=re.compile(r'([\d]*\:)+');
empty_node=[x for x in obj['nodelist'] if (not ipv4_pattern.match(x['nodemgrip'])) and (not ipv6_pattern.match(x['nodemgrip']))];
[obj['nodelist'].remove(n) for n in empty_node];

json.dump(obj, open('${networkinfo_NCE_json_path}', 'w'), indent=2)"

pypath="/opt/NCEICMR/python"
if [ -d ${pypath} ];then
    unset PYTHONSTARTUP PYTHONHOME
    LD_LIBRARY_PATH=$pypath/lib:${LD_LIBRARY_PATH}
    export LD_LIBRARY_PATH
    PATH=$pypath/lib:${PATH}
    pycmd=$pypath/bin/python
    $pycmd -c "${cmd}"
else
    command -v python >/dev/null 2>&1
    if [ $? -ne 0 ];then
        python3 -c "${cmd}"
    else
        python -c "${cmd}"
    fi
fi
exit $?
