#!/bin/bash
#扫描包前置检查:检查上传包任务是否完成

SCRIPT_PATH=$(cd $(dirname $0);pwd)

function create_check_file()
{
    echo "#!/bin/bash
echo RESULT:$1
    ">${SCRIPT_PATH}/scan_packages_post_check_result.sh
    chmod 750 ${SCRIPT_PATH}/scan_packages_post_check_result.sh
}

function post_check()
{
    timeout=0
    create_check_file "1"
    
    while true
    do
        if [ ${timeout} -ge 3600 ]
        then
            create_check_file "255"
            echo "Uploading the product software package timed out."
            break
        fi
        if [ -f "/opt/install/upload_app_pkg.flag" ]
        then
            create_check_file "100"
            rm -rf "/opt/install/upload_app_pkg.flag"
            echo "Product software package uploaded done."
            break
        fi
        timeout=$(expr ${timeout} + 10)
        echo "Uploading the product software package, Please wait..."
        sleep 10
    done
}

post_check
