#!/usr/bin/bash

# SET_TIME_FLAG
hwclock --systohc
hwclock -w

disk_list=(`lsblk -o TYPE,NAME | grep -i "^disk" | awk '{print $2}' | sed 's#^#/dev/#g' | awk '{print length, $0}' | sort -n | sed 's/^.* //g'`)

arch_env=`arch`

# skip X86
if [ "${arch_env}" != "aarch64" ];then
    return 0
fi

for ((i = ${#disk_list[*]} - 1; i >= 0; i--))
do
    disk_name="${disk_list[$i]}"
    dd if=/dev/zero of=$disk_name count=200K bs=512 seek=2054144 > /dev/null 2>&1
    # echo "y" | mkfs.ext2 $disk_name > /dev/null 2>&1
done

return 0