#!/bin/bash

function logger()
{
  local curtime=`date "+%Y-%m-%d %H:%M:%S"`
  echo "[$curtime] $*" >> $logger_file
}

function new_expect() {
cat >> $tmpscript <<SCRIPT
    #!expect
    set timeout $timeout
    log_file $buffer_path
    spawn sftp -P $sftp_port $sftp_user@$sftp_ip
    expect {
    "*yes/no*" {
        send "yes\r"
        exp_continue
    }
    "*@${sftp_ip}*" {
        send "$sftp_pwd\r"
    }
    "*assword:" {
        send "$sftp_pwd\r"
    }
    }

    expect {
    "*assword:" {
        exit 1
    }
    "sftp>" {
        send "ls\r"
    }
    }

    expect "sftp>" {
        send "cd $initdatabackup\r"
    }

    expect {
    "*No such file or directory" {
        exit 1
    }
    "sftp>" {
        send "ls\r"
    }
    }

    expect {
    "*not found" {
        exit 1
    }
    "sftp>" {
        send "ls\r"
    }
    }
    expect {
    "*sftp>*" {
        exit 0
    }
    }

    expect "100%"
    expect timeout {
        exit 1
    }
SCRIPT
}

function main() {
    sftp_ip=$1
    sftp_port=$2
    sftp_user=$3
    sftp_pwd=$4
    initdatabackup=$5
    logger_file="/opt/oss/System_Commissioning/check_backup_server_param_${sftp_ip}.log"
    tmpscript="/opt/oss/System_Commissioning/check_backup_server_param_${sftp_ip}.exp"
    timeout=120
    rm -rf $tmpscript
    new_expect
    buffer="$(expect $tmpscript)"
    res=$?
    logger "the expect buffer is ${buffer}"
    rm -rf $tmpscript
    if [ $res -eq 1 ];then
      echo "Check failed"
      return 1
    fi
    echo "Check successful"
    return 0
}

main $*