#!/bin/bash
SCRIPT_PATH=$(cd $(dirname $0);pwd)


Main() {
  # 防呆，结果文件
  if [ ! -f "${SCRIPT_PATH}/restart_apps.flag" ]; then
    touch "${SCRIPT_PATH}/restart_apps.flag"
  fi
  product_name=$1
  MACHINE_MACHINE_ACCOUNT=$2
  echo ${product_name}
  echo ${MACHINE_MACHINE_ACCOUNT}
  if [ -f "${SCRIPT_PATH}/get_app_ip.pyc" ]; then
    EXPAND_FILE=get_app_ip.pyc
  else
    if [ -f "${SCRIPT_PATH}/get_app_ip.py" ]; then
      EXPAND_FILE=get_app_ip.py
    else
      echo "Error: Can not find get_app_ip file"
      return 1
    fi
  fi
  chown ossadm:ossgroup ${SCRIPT_PATH}/${EXPAND_FILE}
  chown ossadm:ossgroup ${SCRIPT_PATH}
  touch ${SCRIPT_PATH}/app_ip.txt
  chown ossadm:ossgroup ${SCRIPT_PATH}/app_ip.txt
  su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh; python ${SCRIPT_PATH}/${EXPAND_FILE}"
  if [ $? -ne 0 ]; then
    echo "Error: Failed to get app node ip."
    return 1
  fi
  app_ip=$(cat ${SCRIPT_PATH}/app_ip.txt)
  echo ${app_ip}
  cmd_stop="ssh ${app_ip} -o stricthostkeychecking=no /opt/oss/manager/agent/bin/ipmc_adm -cmd stopnodes -tenant ${product_name}"
  echo $cmd_stop
  su - ${MACHINE_MACHINE_ACCOUNT} -c "${cmd_stop}"
  if [ $? -ne 0 ]
  then
      echo "Error: Failed to execute stop nodes."
      return 1
  fi
  cmd_start="ssh ${app_ip} -o stricthostkeychecking=no /opt/oss/manager/agent/bin/ipmc_adm -cmd startnodes -tenant ${product_name}"
  echo $cmd_start
  su - ${MACHINE_MACHINE_ACCOUNT} -c "${cmd_start}"
  start_code=$?
  echo $start_code >"${SCRIPT_PATH}/restart_apps.flag"
  if [ $start_code -ne 0 ]; then
    echo "Error: Failed to execute start nodes."
    return $start_code
  fi
  rm ${SCRIPT_PATH}/app_ip.txt
}
Main $*
exit $?
