#!/bin/bash
#==============================================================
# Copyright  Huawei Technologies Co., Ltd. 1998-2012. All rights reserved.
# File Name             : setLocalIP.sh
# Version:Data          : 
# Description           : modifty /etc/sysconfig/network/ifcfg-X
# Others                : 
# History               : 
#==============================================================


MODULE_NAME="`basename $0 | sed 's/.sh//g'`"
RELATIVE_PATH="`dirname $0`"
#get absolute path
cd "${RELATIVE_PATH}"
ABSOLUATELY_PATH=`pwd`
#import common variable..
. ../common/error_code.inc
. ../common/common.inc
cd - >/dev/null 2>&1

# Name        : fn_write_operation_log
# Description : write operation log
# Parameters  : $1 return value
function fn_write_operation_log()
{
    local RETCODE=$1
    who am i | egrep -w '([0-9]{1,3}\.){3}([0-9]{1,3})' &> /dev/null 
    if [ $? -eq 0 ]
    then
        OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
        OPERIP="${OPERIP//:*/}"
    else
        OPERIP=''
    fi
    
    if [ "${RETCODE}" = 0 ]
    then
        echo "`date` `hostname` `whoami` setNTPServer.sh;Successful;;Set NTP server Successfully." >> /var/log/localmessages
    else
        echo "`date` `hostname` `whoami` setNTPServer.sh;Failed;Set NTP server Failed." >> /var/log/localmessages
    fi    
    chmod 640 /var/log/localmessages
    
    return 0;
}

# Name        : fn_get_config
# Description : get the config from osmu
# Parameters  : $1 the absoluately path of config file 
# Parameter   : $2 the index of host
# Parameter   : $3 get slot number
# Parameter   : $4 get smm card ip
function fn_get_config()
{
    
    local TMP_CONFIG_FILE=$1 
   
    local IP_SERVER_LIST_STRING
    local DOMAIN_SERVER_LIST_STRING
    local TMP_CONTENT_FLAG
    local TMP_TIME
    local TMP_DATE
    
    PRINT_LOG "INFO" "Loading <${TMP_CONFIG_FILE}>.." > /dev/null 2>&1
    
    IP_SERVER_LIST_STRING=`fn_get_value "${TMP_CONFIG_FILE}" "NTP_SERVER_IP"`
    DOMAIN_SERVER_LIST_STRING=`fn_get_value "${TMP_CONFIG_FILE}" "NTP_SERVER_DOMAIN"`
    if [ -z "${IP_SERVER_LIST_STRING}" ] && [ -z "${DOMAIN_SERVER_LIST_STRING}" ]
    then
        PRINT_LOG "WARN" "The param NTP_SERVER<${IP_SERVER_LIST_STRING}><${DOMAIN_SERVER_LIST_STRING}> could not be found!" 
        return 1;
    fi

    local SERVER_LIST
    SERVER_LIST=($(echo ${IP_SERVER_LIST_STRING} | tr ";" " "))
    for server in ${SERVER_LIST[@]}
    do
        fn_validate_ip "${server}" > /dev/null 2>&1
        if [ $? -ne 0 ]
        then
            echo "The server IP $server is illegal"
            return 1
        fi
    done

    if [ -n "${DOMAIN_SERVER_LIST_STRING}" ]
    then
        SERVER_LIST=($(echo "${IP_SERVER_LIST_STRING};${DOMAIN_SERVER_LIST_STRING}" | tr ";" " "))
    fi
    eval $2="(${SERVER_LIST[@]})"
        
    PRINT_LOG "INFO" "Loading <${TMP_CONFIG_FILE}>.. OK!!!" > /dev/null 2>&1
    return 0;
}

function fn_set_ntp_server()
{
    local NTP_SERVER_LIST=$1
    local NTP_CONFIG_FILE="/etc/ntp.conf"
    local SERVER_LIST
    SERVER_LIST=($NTP_SERVER_LIST)
    
    for server in ${SERVER_LIST[@]}
    do
        cat /etc/ntp.conf | grep -v "^#" | grep "^server $server" > /dev/null 2>&1
        if [ $? -ne 0 ]
        then
            echo "server $server maxpoll 4 minpoll 3" >> $NTP_CONFIG_FILE
        fi 
    done

    cat /etc/ntp.conf | grep -v "^#" | grep "prefer" > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
        sed -i "s/^server ${SERVER_LIST[0]} .*/& prefer/" $NTP_CONFIG_FILE
    fi

    service ntpd restart
    return $?
}

function fn_main()
{
    local REF_NTP_SERVER_LIST
    PRINT_LOG "INFO" "bash $0 $1"

    if [ $# -lt 1 ]
    then
        PRINT_LOG "FATAL" "Usage: $0 <config file>"
        PRINT_LOG "FATAL" "e.g:      $0 /usr/local/tools/maintain_tools/sample.properties"
        fn_check_status "${ERROR_PARAM}"
    fi
    CONFIG_FILE=`echo "$1" | sed 's/\\\/\//g'`
    
    sed -i "s/[[:space:]]*$//g" "${CONFIG_FILE}"
    fn_check_config_file "${CONFIG_FILE}" || return $?

    #获取目标参数
    fn_get_config "${TMP_CONFIG_FILE}" REF_NTP_SERVER_LIST
    fn_check_status "$?"  "fn_get_config"


    fn_set_ntp_server "${REF_NTP_SERVER_LIST[*]}"
    fn_check_status "$?"  "fn_set_ntp_server"

    return ${SUCCESS_CODE};
}

#=======================================================================
fn_main "$@"
ret=$?
fn_write_operation_log ${ret}
FUNC_CLEAN_TMP_FILE
exit ${ret}
#=======================================================================
