#!/bin/bash

if [ "$#" = "3" -a "$2" = "-path" ]
then
    installDir=$3
else
    installDir=/opt/expansion
fi

#log
OperateLog()
{
    if [ -f "/opt/NCEICMR/scripts/OperationLog/businessoperatelog.sh" ]
    then
        bash /opt/NCEICMR/scripts/OperationLog/businessoperatelog.sh "$1" "$2"
        return
    fi
}

InitDefaultBackServer()
{
    Pw=`cat $installDir/input.json | grep FTP_PASSWD | awk -F : '{print $2}' | awk -F \" '{print $2}'`
    echo "{
    \"backupmode\": \"SFTP\",
    \"NFS\": {
        \"nfsbackuppath\": \"/export/home/backup\"
    },
    \"SFTPList\": [
        {
        \"SFTPServerIPAddress\": \"${BackServerIP}\",
        \"username\": \"ftpuser\",
        \"password\": \"${Pw}\",
        \"backuppath\": \"backup\",
        \"tmppath\": \"/opt/oss/backuptmp\"
        }
    ]
    }" >$installDir/defaultBackServer.json

    chmod 640 $installDir/defaultBackServer.json
    chown ossadm:ossgroup $installDir/defaultBackServer.json
    return 0
}

Main()
{
    BackServerIP=$1
    echo $BackServerIP |grep "^[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}$" > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
        echo -e "the $BackServerIP is invalid ip\n\t"
        echo "RESULT:255"
        return 1
    fi
    InitDefaultBackServer $BackServerIP
    
    echo "Config default backup server."
    su - ossadm -c "bash /opt/oss/manager/tools/backuprestore/setglobalpara.sh -input $installDir/defaultBackServer.json"
    if [ $? -ne 0 ];then
        echo "Failed to config backup server."
        OperateLog "Error: Failed to config backup server." "error"
        echo "RESULT:255"
        return 1
    fi
    echo "Succeeded to config backup server."
    echo "RESULT:100"
    return 0
}

Main $*
exit $?
