#!/bin/bash
# 处理networkinfo_NCE.json和input.json中的空数据
LOG_FILE=/opt/expansion/deal_empty_nodes.sh.log

function LOG()
{
    if [ "$1" = "ERROR" -o "$1" = "error" ]
    then
        Level="ERROR"
        echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${SELF_FILE}] ${Level} | $2" 1>&2
        echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${SELF_FILE}] ${Level} | $2" >> "${LOG_FILE}"
        logger -p local0.error "[${SELF_FILE}] ${Level} | $2"
    else
        Level="INFO"
        echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${SELF_FILE}] ${Level} | $2" | tee -a "${LOG_FILE}"
        logger -p local0.info "[${SELF_FILE}] ${Level} | $2"
    fi
    chown ossadm: ${LOG_FILE}
}

Main()
{
    # deal empty nodes
    if [ -f "/opt/expansion/deal_empty_nodes.pyc" ]
    then
        PYTHON_FILE=deal_empty_nodes.pyc
    else
        if [ -f "/opt/expansion/deal_empty_nodes.py" ]
        then
            PYTHON_FILE=deal_empty_nodes.py
        else
            LOG  "ERROR"  "Can not find replace_input file"
            return 1
        fi
    fi
    chown ossadm: ${PYTHON_FILE}
    chown ossadm: /opt/expansion/networkinfo_NCE.json
    su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh; python /opt/expansion/${PYTHON_FILE}"
    if [ $? -eq 0 ]
    then
        LOG  "INFO"  "deal empty nodes for network.json and input.json success."
    else
        LOG  "INFO"  "deal empty nodes for network.json and input.json unsuccessful."
        return 1
    fi
}

Main $*
exit $?
