#!/bin/bash
. /etc/profile
#install dir
installDir=/opt/expansion
getPackageName()
{
    #icmr software package
    icmrPackage="iMasterNCE.*\ICMR_linux-.*64.zip"
    #OSMediation software package
    osMediationPackage="iMasterNCE.*\OSMediation_linux-.*64.zip"
    #uniep package
    uniep="iMasterNCE.*\OMP_linux-.*64"
    #EasySuite package
    EasySuitePackage="iMasterNCE.*\EasySuite"
    #nce package
    ncePackage="iMasterNCE.*"
    if [ "$#" == "2" -a "$1" == "-productname" ]
    then
        productname=$2
        icmrPackage=".*${productname}.*\ICMR_linux-.*64.zip"
        uniep=".*${productname}.*\OMP_linux-.*64"
        EasySuitePackage=".*${productname}.*\EasySuite"
        ncePackage=".*${productname}.*"
    fi
}


#####################################
#2018.2.13���ƽ̨����
#��ǰ�ṩ��ܷ��������IOռ��С��85%��ʱ����ִ��ɨ��������񣬱�֤����ִ�гɹ�
#��ʱ2min�˳�
#####################################
waitIOHealth()
{
    for ((i=0; i<12; i++))
    do
        [ ! -f iostat ] && { return 0; }
        #wait all io util < 85
        isok=`iostat -d -x 1 2 | sed -n '/Device:/,$p' | sed '/Device:/d' | sed '/^$/d'  | awk '{print $NF}'  | awk '{print $NF}'  | awk 'BEGIN {isok = 0}
        {
            for (j = 1; j <= NF; ++j) {
                if ($j > 85) isok = 1
            }
        }
        END {print isok}'`
        [ "$isok" == 0 ] && { echo "io stat is ok"; break; }
        echo "io util is more than 85%, sleep 10 seconds..."
        sleep 10
    done
}

createCheckFile()
{
   
    echo "#!/bin/bash
echo  RESULT:1   
   ">/opt/expansion/check_scan_result.sh
 
   chmod 550 /opt/expansion/check_scan_result.sh
}
#getWorkPath
GetWorkPath()
{
    dir=`dirname $0`
    ispointstart=`echo $dir|awk -F/ '{print $1}'`
    if [ "$ispointstart" = "." ]
    then
        dir=`echo $dir|sed 's/^.//'`
        curPath="`pwd`$dir"
    elif [ "$ispointstart" = ".." ]
    then
        curPath="`pwd`/$dir"
    else
        curPath="$dir"
    fi
    return 0
}

#check root user
CheckUser()
{
    USER_ID=`id -u`
    if [ $USER_ID -ne 0 ]
    then
        echo "Run the script as the root user."
        return 1
    fi

    return 0
}

getcheckResult()
{
   if [ $1 -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf /opt/expansion/check_scan_result.sh
   ">/opt/expansion/check_scan_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf /opt/expansion/check_scan_result.sh
   ">/opt/expansion/check_scan_result.sh
   fi
   chmod 550 /opt/expansion/check_scan_result.sh > /dev/null 2>&1
}

#log
OperateLog()
{
    if [ -f "/opt/NCEICMR/scripts/OperationLog/businessoperatelog.sh" ]
    then
        bash /opt/NCEICMR/scripts/OperationLog/businessoperatelog.sh "$1" "$2"
        return
    fi
}

#install product
Install()
{ 
    chmod -R 750 $installDir > /dev/null 2>&1
    #������ɵ�
    rm -rf /opt/oss/manager/var/tmp/*
    rm -rf /opt/pub/software/services/*
    #������Ʒ��
    ncePackageList=`ls $installDir | grep "^$ncePackage" | egrep -v "grep|${uniep}|${icmrPackage}|${EasySuitePackage}|${osMediationPackage}"`
    if [ "$ncePackageList" != "" ]
    then
        for package in ${ncePackageList}
        do
        {
            cp -rf $installDir/${package} /opt/oss/manager/var/tmp
        }
        done
    fi
    # 要根据实际/opt/oss/manager/var/tmp权限复制
    chown -R ossadm:ossgroup /opt/oss/manager/var/tmp
    
    
    #####################################
    #2018.2.13���ƽ̨����
    #��ǰ�ṩ��ܷ��������IOռ��С��85%��ʱ����ִ��ɨ��������񣬱�֤����ִ�гɹ�
    #####################################
    waitIOHealth

    #scan silent
    su - ossadm -c "cd /opt/oss/manager/tools/deployapp && bash scanpackage.sh"
    if [ $? -ne 0 ]
    then
        OperateLog "Error: Install product: scan silent failed, rendering the install_uniep.sh script failed." "error"
        return 1
    fi
    
    return 0
}

Main()
{
    getPackageName $*
    GetWorkPath
    createCheckFile
    CheckUser
    if [ $? -ne 0 ]
    then
        OperateLog "Error: Failed to check the logged-in user, rendering the install_uniep.sh script failed." "error"
        return 1
    fi
    #install
    Install
    if [ $? -ne 0 ]
    then
        OperateLog "Error: Failed to init the software package, rendering the install_uniep.sh script failed." "error"
        return 1
    fi
    
   return 0
}

Main $*
getcheckResult $?
exit $?