#!/bin/bash
USER=$(whoami)
MODULE_NAME="$(basename $0)"
installDir=/opt/install

#create action.json check file
createCheckFile()
{

    echo "#!/bin/bash
echo  RESULT:1
   ">/opt/install/check_addproduct_result.sh

   chmod 750 /opt/install/check_addproduct_result.sh
}

#getWorkPath
getWorkPath()
{
    dir=`dirname $0`
    ispointstart=`echo $dir|awk -F/ '{print $1}'`
    if [ "$ispointstart" = "." ]
    then
        dir=`echo $dir|sed 's/^.//'`
        curPath="`pwd`$dir"
    elif [ "$ispointstart" = ".." ]
    then
        curPath="`pwd`/$dir"
    else
        curPath="$dir"
    fi
    return 0
}
getWorkPath

logFile="${curPath}/${MODULE_NAME}.log"

#log
OperateLog()
{
    BASH_PID=$$
    if [ ! -f ${logFile} ]
    then
        touch ${logFile}
        chmod 640 ${logFile}
        chown ossadm:ossgroup ${logFile}
    fi

    echo $1 | grep -i "ERROR" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="ERROR"
    fi
    echo $1 | grep -i "WARN" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="WARN"
    fi
    if [ -z "${Level}" ]
    then
        Level="INFO"
    fi

    echo "[$(date '+%Y-%m-%d %H:%M:%S')] [${BASH_PID}] | ${Level} $2" | tee -a ${logFile}
}

getcheckResult()
{
   if [ $1 -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf /opt/install/check_addproduct_result.sh
   ">/opt/install/check_addproduct_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf /opt/install/check_addproduct_result.sh
   ">/opt/install/check_addproduct_result.sh
   fi
   chmod 750 /opt/install/check_addproduct_result.sh > /dev/null 2>&1
}

checkPackage()
{
    #1：检查模板文件
    if [ ! -f $installDir/nodes_NCE.json ] || [ ! -f  $installDir/product_NCE.json ]
    then
        OperateLog "error" "Error: the nodes.json or product.json is not exists, rendering the install_uniep.sh script failed."
        return 1
    fi
}

deleteproduct()
{
    #检查产品是否已添加
    if [ -f /tmp/product ];then
        rm -rf /tmp/product
    fi
    mkdir -p /tmp/product

    cd /opt/oss/manager/tools/resmgr && bash queryproduct.sh -pn NCE -output /tmp/product > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "Product NCE not exist. Skip delete."
        return 0
    fi

    cd /opt/oss/manager/tools/resmgr && bash deleteproductinfo.sh -pn NCE -output /tmp/product > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "Failed to delete product NCE."
        return 1
    fi

    rm -rf /tmp/product
    echo "Delete product NCE success."
    return 0
}

addproduct()
{
    chmod -R 750 $installDir
    nodemgrip=$(cat $installDir/networkinfo_NCE.json|grep "nodemgrip"|awk -F":" '{print $2}'|sed 's/,//')
    ip=$(cat $installDir/networkinfo_NCE.json|grep "ip"|grep -v "nodemgrip"|awk -F":" '{print $2}'|sed 's/,//')
    if [ "${nodemgrip}" == "${ip}" ]
    then
        cd /opt/oss/manager/tools/resmgr && bash setproductinfo.sh -product ${installDir}/product_NCE.json -nodes ${installDir}/nodes_NCE.json
    else
        cd /opt/oss/manager/tools/resmgr && bash setproductinfo.sh -product ${installDir}/product_NCE.json -nodes ${installDir}/nodes_NCE.json -networkinfo ${installDir}/networkinfo_NCE.json
    fi
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Failed to add product, rendering the install_uniep.sh script failed."
        return 1
    fi
    if [ -f "/opt/oss/manager/adapter/postaddnode.sh" ];then
        bash /opt/oss/manager/adapter/postaddnode.sh
    fi
}

fn_main()
{
    createCheckFile

    #检查部署文件
    checkPackage
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Failed to check the package, rendering the install_uniep.sh script failed."
        return 1
    fi

    #卸载产品
    deleteproduct
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Failed to delete product, rendering the install_uniep.sh script failed."
        return 1
    fi

    addproduct
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Failed to add product, rendering the install_uniep.sh script failed."
        return 1
    fi

    sleep 30
    bash ${curPath}/addproduct_post_check.sh "${MODULE_NAME}" "${curPath}"
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Failed to post check, rendering the install_uniep.sh script failed."
        return 1
    fi
    sleep 30
    return 0
}

id | grep "ossadm" &>/dev/null
if [ $? -eq 0 ]
then
    fn_main
    getcheckResult $?
    RESULT=$?
else
    chmod -R 750 ${curPath}
    chown -R ossadm:ossgroup ${curPath}
    su - ossadm -c "cd ${curPath} && bash ${MODULE_NAME} $*"
    RESULT=$?
fi

if [ ${RESULT} -eq 0 ]
then
    logger -t ${USER} -p local0.info "${MODULE_NAME}; INFO: Succeeded to add product."
else
    logger -t ${USER} -p local0.err "${MODULE_NAME}; Error: Failed to add product."
fi
exit ${RESULT}
