#!/bin/bash
# remove empty nodes of nodes_NCE.json
node_NCE_json_path=$1

cmd="import json, re;obj=(json.load(open('${node_NCE_json_path}')));ipv4_pattern=re.compile(r'[\d]+\.[\d]+\.[\d]+\.[\d]');ipv6_pattern=re.compile(r'([\d]*\:)+');empty_node=[x for x in obj['hostlist'] if (not ipv4_pattern.match(x['nodemgrip'])) and (not ipv6_pattern.match(x['nodemgrip']))];[obj['hostlist'].remove(n) for n in empty_node];json.dump(obj, open('${node_NCE_json_path}', 'w'), indent=2)"

pypath="/opt/NCEICMR/python"
if [ -d ${pypath} ];then
    unset PYTHONSTARTUP PYTHONHOME
    LD_LIBRARY_PATH=$pypath/lib:${LD_LIBRARY_PATH}
    export LD_LIBRARY_PATH
    PATH=$pypath/lib:${PATH}
    pycmd=$pypath/bin/python
    $pycmd -c "${cmd}"
else
    command -v python >/dev/null 2>&1
    if [ $? -ne 0 ];then
        python3 -c "${cmd}"
    else
        python -c "${cmd}"
    fi
fi
exit $?
