#!/bin/bash

SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)
# 当前任务时间戳
TAIL=$(date +%Y%m%d%H%M%S)

LOG_FILE="/var/log/${SELF_FILE//.sh/}_${TAIL}.log"


function LOG()
{
    if [ "$1" = "ERROR" -o "$1" = "error" ]
    then
        Level="ERROR"
        echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${SELF_FILE}] ${Level} | $2" 1>&2
        echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${SELF_FILE}] ${Level} | $2" >> "${LOG_FILE}"
        logger -p local0.error "[${SELF_FILE}] ${Level} | $2"
    else
        Level="INFO"
        echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${SELF_FILE}] ${Level} | $2" | tee -a "${LOG_FILE}"
        logger -p local0.info "[${SELF_FILE}] ${Level} | $2"
    fi
}

# 获取OMP_01的ip地址
function get_omp01_ip()
{
    local manager_ips=$(cat /opt/oss/manager/var/agent/managerip.conf | \
    grep -w 'managerip' | awk -F= '{print $2}' | sed 's/,/\n/g')
    local node_ips=$(cat /opt/oss/manager/var/tenants/manager/nodelist.json | python -c "import json; import sys; \
    obj=json.load(sys.stdin); print (obj['nodeList']['0']['IPAddresses'])" | sed 's/,/\n/g' | grep -w 'IP' | \
    awk -F"'" '{print $(NF-1)}')
    SETIP=""
    for tmp_node0 in ${node_ips}
    do
        for tmp_manager in ${manager_ips}
        do
            if [ "${tmp_manager}" == "${tmp_node0}" ]
            then
                SETIP="${tmp_manager}"
                return 0
            fi
        done
    done
}

# 判断节点是否需要执行，只有omp节点才能执行这个脚本
function check_need()
{
    localip=$(su - ossadm -c '. /opt/oss/manager/bin/engr_profile.sh;python -c "from util import common;print(common.get_local_ip())"')
    get_omp01_ip
    if [ "${localip}" == "${SETIP}" ]
    then
        return 0
    else
        return 1
    fi
}

# 启动sshd加固
function config_sshd()
{
    LOG "INFO" "Start to add omm user permission."
    sshd_tool="/opt/oss/manager/agent/bin/sshd_ipsadm.sh"
    if [ -f "${sshd_tool}" ]
    then
        # 启动加固，开放omm
        su - ossadm -c "bash ${sshd_tool} -cmd set -extuser omm >/dev/null 2>&1"
        if [ $? -ne 0 ]
        then
            su - ossadm -c "bash ${sshd_tool} -cmd restore >/dev/null 2>&1"
            LOG "ERROR" "Execute '/opt/oss/manager/agent/bin/sshd_ipsadm.sh -cmd set -extuser omm' Failed."
            return 1
        else
            LOG "INFO" "Succeeded in adding the rights of user omm."
            return 0
        fi
    else
        LOG "ERROR" "/opt/oss/manager/agent/bin/sshd_ipsadm.sh not found."
        return 1
    fi
}

# 执行sshd加固，仅在某一管理面执行
function sek_sshd()
{
    rm -rf /opt/fi > /dev/null 2>&1
    
    check_need
    if [ $? -eq 0 ]
    then
        config_sshd
        if [ $? -ne 0 ]
        then
            LOG "ERROR" "Failed to execute the sek_fi.sh script."
            return 1
        fi
    else
        return 0
    fi
}

function main()
{
    # 执行sshd加固，增加omm用户白名单
    sek_sshd || return 1
}

main $*
exit $?
