#!/bin/bash
#脚本记录日志
if [ ! -d /var/ICMR ];then
    mkdir -p /var/ICMR
fi
logFile="/var/ICMR/uninstall_u2000.log"
rm ${logFile} > /dev/null 2>& 1
touch ${logFile} > /dev/null 2>& 1
function LOG()
{
    if [ "$1" = "ERROR" ];then
        Level="ERROR"
    elif [ "$1" = "WARN" ];then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "`date +%Y`-`date +%m`-`date +%d` `date +%H`:`date +%M`:`date +%S`| ${Level} $2">>${logFile}
}
#删除Sybase数据库日志绕接任务
function deleteSybaseDBCron()
{
    dbmonitorScriptPath="/opt/oss/manager/tools/dbmonitor"
    
    #判断此脚本是否在在
    if [ -f "${dbmonitorScriptPath}/dblogmonitor.sh" ]
    then
        #判断此脚本是否可执行
        if [ ! -x "${dbmonitorScriptPath}/dblogmonitor.sh" ]
        then
            logger -p local0.info "uninstall_u2000.sh;dblogmonitor.sh is exist but not executable;fail to delete cron task for dblogmonitor.sh."
            return 1
        fi
        LOG "INFO" "Start to run dblogmonitor.sh."
        sh "${dbmonitorScriptPath}/dblogmonitor.sh" "uninstall" >>${logFile} 2>&1
        if [ $? -ne 0 ]
        then
            LOG "ERROR" "Start to run dblogmonitor.sh."
            logger -p local0.info "uninstall_u2000.sh;fail to delete cron task for dblogmonitor.sh."
            return 1
        else
            LOG "INFO" "Finish to run dblogmonitor.sh."
            logger -p local0.info "uninstall_u2000.sh;delete cron task for dblogmonitor.sh successfully."
            return 0
        fi
    else #脚本不在在，不是Sybase节点，不需要删除相关绕接任务
        LOG "INFO" "uninstall_u2000.sh;it is no dblogmonitor.sh;no sybase,no need to delete related cron task.successful"
        logger -p local0.info "uninstall_u2000.sh;it is no dblogmonitor.sh;no sybase,no need to delete related cron task.successful"
        return 0
    fi
}

Main()
{
    deleteSybaseDBCron
    
    if [ -f "/opt/oss/manager/agent/tools/shscript/uninstall.sh" ]
    then
        LOG "INFO" "Start to run uninstall.sh."
        su - ossadm -c "cd /opt/oss/manager/agent/tools/shscript && bash uninstall.sh -f" >>${logFile} 2>&1
        if [ $? -ne 0 ];then
            LOG "INFO" "Failed to run uninstall.sh."
            return 1
        fi
        sed -i '/^ossuser/d' /etc/security/opasswd >>${logFile} 2>&1
        rm -rf /opt/backup/smp/* >>${logFile} 2>&1
        LOG "INFO" "Finish to run uninstall.sh."
        return 0
    fi
}

Main
exit 0
