#!/bin/bash
installDir=/opt/install
. /etc/profile

PRODUCT_NAME=NCE
if [ $# -eq 1 ]; then
  PRODUCT_NAME=$1
fi

# 读取密码
echo "es_input: product_pwd_ftpuser"
read -rs product_pwd_ftpuser
if [ "X${product_pwd_ftpuser}" == "X" ];then
    exit 1
fi

echo "es_input: product_pwd_admin_web_service"
read -rs product_pwd_admin_web_service
if [ "X${product_pwd_admin_web_service}" == "X" ];then
    exit 1
fi

echo "es_input: product_pwd_ossadm"
read -rs product_pwd_ossadm
if [ "X${product_pwd_ossadm}" == "X" ];then
    exit 1
fi

chmod 600 "${installDir}"/input.json
chmod 600 "${installDir}"/nodes_${PRODUCT_NAME}.json

if [ -d ${installDir}/commonE ]
then
    chmod 600 "${installDir}"/commonE/input.json
    chmod 600 "${installDir}"/commonE/nodes_NCETENANT.json
fi

PY_FILE=${installDir}/$(ls ${installDir} | grep encrypt_pwdfile.py | awk 'FNR == 1')
chown ossadm:ossgroup ${PY_FILE}
chmod 700 ${PY_FILE}

(echo $PRODUCT_NAME; echo $product_pwd_ftpuser; echo $product_pwd_admin_web_service; echo $product_pwd_ossadm;) | su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh >/dev/null 2>&1;cd /opt/install;python -c \"import encrypt_pwdfile; encrypt_pwdfile.replace_pwd('/opt/install')\""
RESULT=$?

if [ ${RESULT} -eq 0 ]
then
    logger -t ${USER} -p local0.info "${MODULE_NAME}; INFO: update pwd in input.json success."
else
    logger -t ${USER} -p local0.err "${MODULE_NAME}; Error: Failed update pwd in input.json."
fi
exit ${RESULT}
