#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
# File name: common.sh
# Description: frame function

#############################################################
#  功能说明:控制整个EasySuite工作路径文件权限,只刷权限不刷属组
#  构建脚本也会引用,除了刷目录下文件权限外，其他操作不能放
#############################################################
function chmod_permit()
{
  find ${work_path} -path "${python_path}" -prune -o -type d | xargs -i echo "'{}'" | xargs chmod --silent 750
  find ${work_path} -path "${python_path}" -prune -o -type f | xargs -i echo "'{}'" | xargs chmod --silent 640

  # 刷新压缩包和签名校验工具文件权限
  [ -d "${zip_tool_path}" ] && find ${zip_tool_path} -type f | xargs -i echo "'{}'" | xargs chmod --silent 550
  [ -d "${verify_tool_path}" ] && find ${verify_tool_path} -type f | xargs -i echo "'{}'" | xargs chmod --silent 550
  find ${certs_path} -type f | xargs -i echo "'{}'" | xargs chmod --silent 600 2>/dev/null

  # 刷文件权限
  find ${work_path} -path "${python_path}" -prune -o -type f -name "*.sh" | xargs -i echo '"{}"' | xargs chmod --silent 550 2>/dev/null
  find ${work_path} -path "${python_path}" -prune -o -type f -name "*.pem" -or -name "*.cer" -or -name "*.p12" -or -name "*.keystore" -or -name "*.jks" -or -name "*.crt" -or -name "*.der" -or -name "*.pfx" -or -name "*.cer"| xargs -i echo '"{}"' | xargs chmod --silent 600 2>/dev/null
  find ${work_path} -path "${python_path}" -prune -o -type f -name "*.json" -print0 | xargs -0 grep -E -a "[a-zA-Z0-9]{45}" |grep -v site-package |cut -d : -f 1 |xargs chmod --silent 600 2>/dev/null
  find ${work_path} -path "${python_path}" -prune -o -type f -name "*.xml" -print0 | xargs -0 grep -E -a "[a-zA-Z0-9]{45}" |grep -v site-package |cut -d : -f 1 |xargs chmod --silent 600 2>/dev/null
  find ${work_path} -path "${python_path}" -prune -o -type f -name "*.conf" -print0 | xargs -0 grep -E -a "[a-zA-Z0-9]{45}" |grep -v site-package |cut -d : -f 1 |xargs chmod --silent 600 2>/dev/null
  find ${work_path} -path "${python_path}" -prune -o -type f -name "*.properties" -print0 | xargs -0 grep -E -a "[a-zA-Z0-9]{45}" |grep -v site-package |cut -d : -f 1 |xargs chmod --silent 600 2>/dev/null
  find ${work_path} -path "${python_path}" -prune -o -type f -print0 | xargs -0 grep 000000010000 |grep -v site-package |grep -v escompontent |cut -d : -f 1 |grep .json |xargs chmod --silent 600 2>/dev/null
  find ${work_path} -path "${python_path}" -prune -o -type f -name "*.sql" -or -name "*.html" -or -name "*.css" -or -name "*.js" -or -name "*.png" -or -name "*.jpg" -or -name "*.gif" -or -name "*.svg"| xargs -i echo "'{}'" | xargs chmod --silent 440 2>/dev/null
  find ${work_path} -path "${python_path}" -prune -o -type f -name "*.py" -or -name "*.pyc" -or -name "*.so"| xargs -i echo "'{}'" | xargs chmod --silent 550 2>/dev/null

  # 处理python_path目录
  chmod -R 500 "${python_path}" &>/dev/null
  find "${python_path}" -type f | xargs -i echo "'{}'" | xargs chmod --silent 400 2>/dev/null
  chmod 500 "${python_bin_path}" &>/dev/null
  
  # 处理数据库文件权限
  chmod --silent 600 ${work_path}/easysuite/db/easysuite.sqlite3 &>/dev/null
  
  # 刷新秘钥文件和config配置文件权限
  chmod --silent 600 ${work_path}/var/.easysuite/* ${work_path}/easysuite/easysuite/config/* &>/dev/null

  # 刷新敏感文件证书和密钥目录权限
  chmod --silent 700 ${work_path}/var/.easysuite ${work_path}/easysuite/certs &>/dev/null

  # 刷新数据库和config配置目录权限
  chmod --silent 700 ${work_path}/easysuite/db ${work_path}/easysuite/easysuite/config &>/dev/null
}
