#! /usr/bin/env python
# _*_ coding=utf-8 _*_

import json
import re
import sys
import time

from util import httpclient
from util import common


if hasattr(common, 'getDefaultLogger'):
    LOGGER = common.getDefaultLogger()
elif hasattr(common, 'get_default_logger'):
    LOGGER = common.get_default_logger()
elif hasattr(common, 'GET_DEFAULT_LOGGER'):
    LOGGER = common.GET_DEFAULT_LOGGER()
else:
    import logging
    LOGGER = logging.getLogger("default")

_HTTP_CLIENT = httpclient.IRHttpClient()

TIME_OUT= 210
TOTAL_TIMES=21
DISCONNECT_STATUS = 2
ERR_FAILED = 1
SUCCESS = 0
PRODUCT_NAME_REG = "^[A-Za-z0-9-]{1,32}$"
REST_NODE_STATUS = "/rest/plat/sysmgr/v1/main/sysmonitor/nodelist?tenant={productname}"


def check_node_status(rest_url):
    LOGGER.info("start to rest: %s" % rest_url)
    try:
        response = _HTTP_CLIENT.get(rest_url)
        if response is None or response == "":
            LOGGER.error("Argument is invalid.")
            return False
        http_status = response[0]
        if not http_status == 200:
            LOGGER.error('sendGetRest failure, http status code is: %s' % http_status)
            return False
        response = json.loads(response[1])
        if not response.get("status") == "0":
            LOGGER.error('sendGetRest failure, response status code is: %s' % response.get("status"))
            return False
        node_list = json.loads(response.get("result"))
        if not node_list:
            LOGGER.error("NodeStatusList:%s is empty.", node_list)
            return False
        for node in node_list:
            if node.get("connectStatus") != "0":
                LOGGER.error("nodeStatus is disconnected, details:%s", node)
                return False

        LOGGER.info("CheckNodeStatus success.")
        return True
    except Exception as err:
        LOGGER.error('sendGetRest exception: %s' % err)
        return None

def check_product_name_valid(product_name):
    if re.search(PRODUCT_NAME_REG, product_name):
        return True
    LOGGER.error("the product_name: %s is not valided" % product_name)
    return False

def check_url_get_status(rest_url):
    response = _HTTP_CLIENT.get(rest_url)
    LOGGER.info('sendGetRest response is: %s, for url: %s' % (response, rest_url))
    if response is None or response == "":
        LOGGER.error("http get is failed.")
        return False

    http_status = response[0]
    if http_status == 200:
        return True

    LOGGER.error('sendGetRest failure')
    return False

def main():
    LOGGER.info("CheckNodeStatus start")
    if len(sys.argv) < 1:
        LOGGER.error("The input parameter is empty.")
        return ERR_FAILED
    product_name = sys.argv[1]
    LOGGER.info("The productName: %s." % product_name)
    if not check_product_name_valid(product_name):
        time.sleep(TIME_OUT)
        return ERR_FAILED
    rest_url = REST_NODE_STATUS.replace("{productname}", product_name)
    # 接口请求失败，直接等待210s 后退出
    if not check_url_get_status(rest_url):
        time.sleep(TIME_OUT)
        return ERR_FAILED

    try:
        retry_times = 1
        while retry_times <= TOTAL_TIMES:
            if check_node_status(rest_url):
                return SUCCESS
            time.sleep(10)
            retry_times += 1

    except Exception as err:
        LOGGER.error("Get the Node Status failure, catch an exception, e=%s." % err)
        return ERR_FAILED
    LOGGER.info("CheckNodeStatus end.")
    return SUCCESS


if __name__ == "__main__":
    main()
    sys.exit(0)
