#!/usr/bin/python
# -*- coding: utf-8 -*-
from common_tasks.check_destination_tables import CheckDestinationTables
from common_tasks.stelnet_template_upgrade_before_r19c00_included import UpgradeStelnetTempalte
from common_tasks.stelnet_paras_upgrade import UpgradeStelnetPara
from common_tasks.protocol_security_config_upgrade import UpgradeProtocolSecurityConfig
from common_tasks.neid_alloc_upgrade import UpgradeNeIdAlloc
from common_tasks.ne_basic_info_upgrade import UpgradeNeBasicInfo
from common_tasks.common_dev_port_info_upgrade import UpgradeCommonDevPortInfo
from common_tasks.privilege_upgrade import UpgradePrivilege
from common_tasks.t_neam_neinfo_upgrade import UpgradeTNeamNeinfo
from common_tasks.netconf_template_upgrade_before_r20c10_excluded import UpgradeNetconfTemplate
from common_tasks.netconf_para_upgrade_before_r19c10_excluded import UpgradeNetconfPara
from common_tasks.snmp_para_upgrade import UpgradeSnmpPara
from common_tasks.snmp_template_upgrade import UpgradeSnmpTemplate
from common_tasks.dev_type_reg_info_upgrade import UpgradeDevTypeRegInfo
from common_tasks.ssh_fingerprint_upgrade import UpgradeSshFingerprint
from common_tasks.ssh_fingerprint_config_upgrade import UpgradeSshFingerprintConfig
from common_tasks.qx_para_upgrade import UpgradeQxPara
from common_tasks.qx_dcn_upgrade import UpgradeQxDcn
from common_tasks.qx_dcn_upgrade_for_router import UpgradeQxDcnForRouter
from common_tasks.common_dev_info_upgrade import UpgradeCommonDevInfo
from common_tasks.local_nm_upgrade import UpgradeLocalNM

# 任务全局变量，需要将任务类注册到这里，以便任务调用框架进行调度。
# 支持声明前置任务，只有前置任务执行结束，才启动该任务的执行；
# 如果前置任务为空，表明可以直接启动该任务；
# 如果前置任务非空，则必须前置任务完成之后，才可以启动当前任务；

COMMON_TASKS = [
    {"pre_tasks": [], "task": CheckDestinationTables, "name": "CheckDestinationTables"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeDevTypeRegInfo, "name": "UpgradeDevTypeRegInfo"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeStelnetTempalte, "name": "UpgradeStelnetTempalte"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeStelnetPara, "name": "UpgradeStelnetPara"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeProtocolSecurityConfig, "name": "UpgradeProtocolSecurityConfig"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeNeIdAlloc, "name": "UpgradeNeIdAlloc"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeLocalNM, "name": "UpgradeLocalNM"},
    {"pre_tasks": ["CheckDestinationTables", "UpgradeDevTypeRegInfo", "UpgradeNeIdAlloc", "UpgradeLocalNM"],
     "task": UpgradeNeBasicInfo, "name": "UpgradeNeBasicInfo"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeCommonDevPortInfo, "name": "UpgradeCommonDevPortInfo"},
    {"pre_tasks": ["CheckDestinationTables", "UpgradeDevTypeRegInfo", "UpgradeNeIdAlloc"], "task": UpgradeCommonDevInfo, "name": "UpgradeCommonDevInfo"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradePrivilege, "name": "UpgradePrivilege"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeTNeamNeinfo, "name": "UpgradeTNeamNeinfo"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeNetconfTemplate, "name": "UpgradeNetconfTemplate"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeNetconfPara, "name": "UpgradeNetconfPara"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeSnmpPara, "name": "UpgradeSnmpPara"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeSnmpTemplate, "name": "UpgradeSnmpTemplate"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeQxPara, "name": "UpgradeQxPara"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeQxDcn, "name": "UpgradeQxDcn"},
    {"pre_tasks": ["CheckDestinationTables", "UpgradeNeBasicInfo"], "task": UpgradeQxDcnForRouter, "name": "UpgradeQxDcnForRouter"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeSshFingerprint, "name": "UpgradeSshFingerprint"},
    {"pre_tasks": ["CheckDestinationTables"], "task": UpgradeSshFingerprintConfig, "name": "UpgradeSshFingerprintConfig"},
]
