#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import os

sys.path.append(str(sys.argv[1]))
import codecs
from getDBConnection import get_zenith_session

def main(product_name="NCE"):
    db_user = input()
    sql_file = input()
    curPath = os.path.dirname(os.path.abspath(__file__))
    exec_file = os.path.join(curPath, sql_file)
    print("excel_sql---main product_name is %s" % product_name)
    db_session = get_zenith_session(db_user, db_user, product_name)
    if db_session is None:
        print("db_session %s is None" % db_user)
        return
    sql_txt = ''
    db_session.autocommit(True)
    db_cursor = db_session.cursor()
    for line in open(exec_file):
        if line.strip() == '':
            continue
        else:
            sql_txt = line.strip()
            try:
                print("sql_txt is %s " % sql_txt)
                db_cursor.execute(sql_txt)
                value = db_cursor.fetchall()
                print(value)
            except Exception as msg:
                print(msg)
    db_cursor.close()
    db_session.close()

if __name__ == '__main__':
    if len(sys.argv) != 3:
        print ('usage: exec_sql.py')
        sys.exit(-1)
    product_name = sys.argv[2]
    print("excel_sql product_name is %s" % product_name)
    main(product_name)
