'''
use this to upgrade ipv4
'''
#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import uuid
import re
import datetime

sys.path.append(str(sys.argv[1]))
from getDBConnection import get_zenith_session

ONE_PACKAGE = 500
ERR_CODE = 0
LEN_EMPTY = 0

UPDATE_SQLS = ["update tFiber a inner join tbl_FiberID2Names b on a.cAONE = b.oneID and b.neID = -1 and b.shelfID = -1 and b.slotID = -1 and b.portID = -1 and (a.cAONEName is null or a.cAONEName = '') set a.cAONEName = b.cName",
               "update tFiber a inner join tbl_FiberID2Names b on b.oneID = -1 and a.cANE = b.neID  and b.shelfID = -1 and b.slotID = -1 and b.portID = -1 and (a.cANEName is null or a.cANEName = '') set a.cANEName = b.cName",
               "update tFiber a inner join tbl_FiberID2Names b on b.oneID = -1 and a.cANE = b.neID  and b.shelfID = a.cAShelf and b.slotID = a.cASlot and b.subSlotID = -1 and b.portID = -1 and (a.cASlotName is null or a.cASlotName = '') set a.cASlotName = b.cName",
               "update tFiber a inner join tbl_FiberID2Names b on b.oneID = -1 and a.cANE = b.neID  and b.shelfID = a.cAShelf and b.slotID = a.cASlot and b.subSlotID = a.cASubSlot and b.portID = a.cAPort and ((a.cACliName is not null and b.cliName = a.cACliName) or ((a.cACliName = '' or a.cACliName is null) and (b.cliName = '' or b.cliName is null))) and (a.cAPortName is null or a.cAPortName = '') set a.cAPortName = b.cName",
               "update tFiber a inner join tbl_FiberID2Names b on a.cZONE = b.oneID and b.neID = -1 and b.shelfID = -1 and b.slotID = -1 and b.portID = -1 and (a.cZONEName is null or a.cZONEName = '') set a.cZONEName = b.cName",
               "update tFiber a inner join tbl_FiberID2Names b on b.oneID = -1 and a.cZNE = b.neID  and b.shelfID = -1 and b.slotID = -1 and b.portID = -1 and (a.cZNEName is null or a.cZNEName = '') set a.cZNEName = b.cName",
               "update tFiber a inner join tbl_FiberID2Names b on b.oneID = -1 and a.cZNE = b.neID  and b.shelfID = a.cZShelf and b.slotID = a.cZSlot and b.subSlotID = -1 and b.portID = -1 and (a.cZSlotName is null or a.cZSlotName = '') set a.cZSlotName = b.cName",
               "update tFiber a inner join tbl_FiberID2Names b on b.oneID = -1 and a.cZNE = b.neID  and b.shelfID = a.cZShelf and b.slotID = a.cZSlot and b.subSlotID = a.cZSubSlot and b.portID = a.cZPort and ((a.cZCliName is not null and b.cliName = a.cZCliName) or ((a.cZCliName = '' or a.cZCliName is null) and (b.cliName = '' or b.cliName is null))) and (a.cZPortName is null or a.cZPortName = '') set a.cZPortName = b.cName",
               "update tbl_Link a inner join tbl_FiberID2Names b on a.cAONE=b.oneID  and b.shelfID=-1 and b.neID=-1 and b.slotID=-1 and b.portID=-1 and (a.cAONEName is null or a.cAONEName = '') set a.cAONEName = b.cName",
               "update tbl_Link a inner join tbl_FiberID2Names b on b.oneID=-1  and b.shelfID=-1 and a.cANE=b.neID and b.slotID=-1 and b.portID=-1 and b.vrID = -1 and (a.cANEName is null or a.cANEName = '') set a.cANEName = b.cName",
               "update tbl_Link a inner join tbl_FiberID2Names b on b.oneID=-1 and b.shelfID=a.cAShelfID and a.cANE=b.neID and b.slotID=a.cASlot and b.slotID!=-1 and b.subSlotID=-1 and b.portID=-1 and (a.cASlotName is null or a.cASlotName = '') set a.cASlotName = b.cName",
               "update tbl_Link a inner join tbl_FiberID2Names b on b.oneID=-1 and b.shelfID=a.cAShelfID and a.cANE=b.neID and b.slotID=a.cASlot and b.subSlotID=a.cASubSlot and b.subSlotID!=-1 and b.portID=-1 and (a.cASubBoardName is null or a.cASubBoardName = '') set a.cASubBoardName = b.cName",
               "update tbl_Link a inner join tbl_FiberID2Names b on b.oneID=-1 and b.shelfID=a.cAShelfID and a.cANE=b.neID and b.slotID=a.cASlot and b.subSlotID=a.cASubSlot and b.portID=a.cAPort and ((a.cAPortName is not null and a.cAPortName = b.cliName) or ((a.cAPortName='' or a.cAPortName is null) and (b.cliName = '' or b.cliName is null))) and b.portID!=-1 and (a.cASrcPortName is null or a.cASrcPortName = '') set a.cASrcPortName = b.cName",
               "update tbl_Link a inner join tbl_FiberID2Names b on b.neID =  a.cANE and (b.vrID =a.cAVRID and a.cAVRID <> -1) and b.oneID= -1 and b.slotID = -1 and b.shelfID = -1 and b.portID = -1 and (a.cAVrName is null or a.cAVrName = '') set a.cAVrName = b.cName",
               "update tbl_Link a inner join tbl_FiberID2Names b on a.cZONE=b.oneID and b.neID=-1 and b.shelfID=-1 and b.slotID=-1 and b.portID=-1 and (a.cZONEName is null or a.cZONEName = '') set a.cZONEName = b.cName",
               "update tbl_Link a inner join tbl_FiberID2Names b on b.oneID=-1 and a.cZNE=b.neID  and b.shelfID=-1 and b.slotID=-1 and b.portID=-1 and b.vrID = -1 and (a.cZNEName is null or a.cZNEName = '') set a.cZNEName = b.cName",
               "update tbl_Link a inner join tbl_FiberID2Names b on b.oneID=-1 and b.shelfID=a.cZShelfID and a.cZNE=b.neID and b.slotID=a.cZSlot  and b.slotID!=-1 and b.subSlotID=-1 and b.portID=-1 and (a.cZSlotName is null or a.cZSlotName = '') set a.cZSlotName = b.cName",
               "update tbl_Link a inner join tbl_FiberID2Names b on b.oneID=-1 and b.shelfID=a.cZShelfID and a.cZNE=b.neID and b.slotID=a.cZSlot and b.subSlotID=a.cZSubSlot and subSlotID!=-1 and b.portID=-1 and (a.cZSubBoardName is null or a.cZSubBoardName = '') set a.cZSubBoardName = b.cName",
               "update tbl_Link a inner join tbl_FiberID2Names b on b.oneID=-1 and b.shelfID=a.cZShelfID and a.cZNE=b.neID and b.slotID=a.cZSlot and b.subSlotID=a.cZSubSlot and b.portID=a.cZPort and ((a.cZPortName is not null and a.cZPortName = b.cliName) or ((a.cZPortName='' or a.cZPortName is null) and (b.cliName = '' or b.cliName is null))) and b.portID!=-1 and (a.cZDstPortName is null or a.cZDstPortName = '') set a.cZDstPortName = b.cName",
               "update tbl_Link a inner join tbl_FiberID2Names b on b.neID =  a.cZNE and (b.vrID =a.cZVRID and a.cZVRID <> -1) and b.oneID= -1 and b.slotID = -1 and b.shelfID = -1 and b.portID = -1 and (a.cZVrName is null or a.cZVrName = '') set a.cZVrName = b.cName"]

class IPAddressMigrate:
    '''
    to migrate ipv4
    '''
    def __init__(self, product_name="NCE"):
        self.ip_range_paras = []
        self.used_ip_paras = []

        self.invbasedb_sess = get_zenith_session('invbasedb', 'invbasedb', product_name)
        if self.invbasedb_sess is None:
            print("[migrate_ipv4_table]invbasedb_sess is None")
            return
        self.invbasedb_sess.autocommit(True)
        self.invbasedb_cursor = self.invbasedb_sess.cursor()

        self.topodb_sess = get_zenith_session('topodb', 'topodb', product_name)
        if self.topodb_sess is None:
            print("[migrate_ipv4_table]get topodb_sess session fail")
            return
        self.topodb_sess.autocommit(True)
        self.topodb_cursor = self.topodb_sess.cursor()
        print('[migrate_ipv4_table]get topodb_sess success!')

        self.mcdb_sess = get_zenith_session('MCDB', 'MCDB', product_name)
        if self.mcdb_sess is None:
            print("[migrate_ipv4_table]mcdb_sess is None")
            return
        self.mcdb_sess.autocommit(True)
        self.mcdb_cursor = self.mcdb_sess.cursor()
        print('[migrate_ipv4_table]get mcdb_sess success')


    def get_nw_ip_range_info(self):
        '''
        get used ip range info
        '''
        print("[get_nw_IPRangeInfo] start")
        self.mcdb_cursor.execute('select rangeID, ipRangeName, startIP, endIP, IsAutoAlloc, '
                                 'strSubNet, isOnlyCrossSubnet from nw_IPRangeInfo')
        ip_range_paras = self.mcdb_cursor.fetchall()
        if ip_range_paras:
            self.ip_range_paras = list(ip_range_paras)

        print("[get_nw_IPRangeInfo] ip range info: %s"%(self.ip_range_paras))

    def get_nw_used_ip_info(self):
        '''
        get used ip from mcdb
        '''
        print("[get_nw_usedIPInfo] start")
        self.mcdb_cursor.execute(
            'select t.rangeID, t.linkID, t.ip, t.netmask, t.portfdn, t.neID, t.ipConf, '
            't.usage, t.updatetime from (select rangeID, linkID, ip, netmask, portfdn,'
            ' neID, ipConf, usage, updatetime, row_number() over (partition by ip, portfdn'
            ' order by rangeID asc) as groupId from nw_usedIPInfo) t where t.groupId = 1')

        used_ip_paras = self.mcdb_cursor.fetchall()
        if used_ip_paras:
            self.used_ip_paras = list(used_ip_paras)

        print("[get_nw_usedIPInfo] used ip info size: %d" % (len(self.used_ip_paras)))

    @staticmethod
    def hex_to_ip(num):
        '''
        :param num:184614910
        :return:388.97.73.16
        '''
        hex_ip = []
        content = []
        for cur in range(4):
            content.append(cur)
            hex_ip.append(str(num % 256))
            num //= 256
        return '.'.join(hex_ip[::-1])

    def get_subnetuuid_from_topo(self, obj_id):
        '''
        get uuid from topo
        '''
        print("[get_subnetuuid_from_topo] get subnet uuid from topo")
        select_stmt = 'select RESID from TOPODB.TBL_NODE where OBJID=%d'%(int(obj_id))
        self.topodb_cursor.execute(select_stmt)
        resids = self.topodb_cursor.fetchall()
        print("[get_subnetuuid_from_topo] get subnet uuid is:%s"%resids)
        if len(resids) == LEN_EMPTY:
            print("[get_subnetuuid_from_topo] can not find subnet uuid, obj_id:%s"%obj_id)
            return ERR_CODE
        return resids[0][0]

    def subnetid_to_uuid(self, subnets):
        '''
        get subnet uuid from topo
        '''
        print("[subnetid_to_uuid] start, old subnets:%s"%subnets)
        new_subnet = subnets
        subnet_list = subnets.split(";")
        pattern = re.compile(r'S(\d+)')
        try:
            new_subnet_list = []
            for subnet in subnet_list:
                if subnet == "":
                    continue
                old_subnet_id = str(pattern.findall(subnet)[0])
                new_subnet_id = self.get_subnetuuid_from_topo(old_subnet_id)
                if new_subnet_id == ERR_CODE:
                    continue
                new_subnet_list.append(new_subnet_id)
            if len(new_subnet_list) == LEN_EMPTY:
                new_subnet_list.append('3')
            new_subnet = ','.join(new_subnet_list)
            print("[subnetid_to_uuid] nw_IPRangeInfo new subnet :%s" % new_subnet_list)
        except ValueError as err:
            print("[subnetid_to_uuid] can not convert subnet id :%s" % new_subnet_list)

        return new_subnet

    def count_ip_used_num(self, start_ip, end_ip):
        '''
        count ip
        '''
        count = 0
        for used_ip_para in self.used_ip_paras:
            curr_ip = int(used_ip_para[2])
            if start_ip <= curr_ip <= end_ip:
                count = count + 1
        return str(count)


    def convert_ip_range_param(self):
        '''
        convert ip range
        '''
        print("[convert_ip_range_param] start ip_range_paras=%s" % self.ip_range_paras)
        result = []
        for ip_range_para in self.ip_range_paras:
            startip = ip_range_para[2]
            endip = ip_range_para[3]
            subnet = ip_range_para[5]

            tmp_ip_range_para = list(ip_range_para)
            tmp_ip_range_para[0] = str(uuid.uuid1())
            tmp_ip_range_para[2] = IPAddressMigrate.hex_to_ip(int(startip))
            tmp_ip_range_para[3] = IPAddressMigrate.hex_to_ip(int(endip))
            tmp_ip_range_para[5] = self.subnetid_to_uuid(subnet)
            tmp_ip_range_para[6] = self.count_ip_used_num(int(startip), int(endip))

            result.append(tmp_ip_range_para)

        print("[convert_ip_range_param] result:%s"%(result))
        self.ip_range_paras.clear()
        self.ip_range_paras = result
        print("[convert_ip_range_param] end")

    def convert_used_ip_info_param(self):
        '''
        convert_used_ip_info_param
        '''
        print("[convert_used_ip_info_param] start used_ip_paras = %s" % self.used_ip_paras)
        result = []
        for used_ip_para in self.used_ip_paras:
            tmp_used_ip_paras = list(used_ip_para)
            tmp_used_ip_paras[0] = str(uuid.uuid1())
            if tmp_used_ip_paras[4] == '' or tmp_used_ip_paras[4] is None:
                print("[fill_usedip_info] can not find the fdn in MCDB, current record is :" + " ".join(
                    str(i) for i in tmp_used_ip_paras))
                continue
            result.append(tmp_used_ip_paras)

        print("[convert_used_ip_info_param] result:%s"%(result))
        self.used_ip_paras.clear()
        self.used_ip_paras = result
        print("[convert_used_ip_info_param] end")


    def convert_param(self):
        '''
        convert_param
        '''
        print("[convert_param] start")
        self.convert_ip_range_param()

        self.convert_used_ip_info_param()

    @staticmethod
    def fill_iprange_info(raw_ip):
        '''
        fill_iprange_info
        '''
        range_id = raw_ip[0]
        name = raw_ip[1]
        startip = raw_ip[2]
        endip = raw_ip[3]
        allocate_type = raw_ip[4]
        subnet_id = raw_ip[5]
        used_num = raw_ip[6]
        current_allocate_ip = '0'
        new_ip = [range_id, name, startip, endip, allocate_type,
                  subnet_id, used_num, current_allocate_ip]
        return tuple(new_ip)

    def insert_ipinfo_to_t_iprange(self):
        '''
        insert_iprange_into_T_IPV4POOL
        '''
        print("[insert_iprange_into_T_IPV4POOL] the size is:%d"%len(self.ip_range_paras))
        insert_stmt = "insert into T_IPV4POOL (ID, NAME, STARTIP, ENDIP, ALLOCTYPE, SUBNETID," \
                      " USEDNUM, CURRENTALLOCATEIP) values(:1,:2,:3,:4,:5,:6,:7,:8)"
        data_list = []
        for ip_range_para in self.ip_range_paras:
            data_list.append(IPAddressMigrate.fill_iprange_info(ip_range_para))
            if len(data_list) == ONE_PACKAGE:
                self.invbasedb_cursor.executemany(insert_stmt, data_list)
                print("[insert_iprange_into_T_IPV4POOL] one package datas:%s"%data_list)
                data_list = []

        print("[insert_iprange_into_T_IPV4POOL] last package datas:%s" % data_list)
        if data_list:
            try:
                self.invbasedb_cursor.executemany(insert_stmt, data_list)
            except ValueError as err:
                print("[insert_iprange_into_T_IPV4POOL] ip_address insert_ipinfo_to_t_iprange error")
            print("[insert_iprange_into_T_IPV4POOL] last package datas:%s"%data_list)

    @staticmethod
    def fill_usedip_info(raw_usedip):
        '''
        fill_usedip_info
        '''
        rangeid = raw_usedip[0]
        ipadress = raw_usedip[2]
        natmask = raw_usedip[3]
        neid = raw_usedip[5]
        fdn = raw_usedip[4]
        ipconf = raw_usedip[6]
        allocatype = raw_usedip[7]
        update_time = raw_usedip[8]
        new_usedip = [rangeid, ipadress, natmask, neid, fdn, ipconf, allocatype, update_time]
        return tuple(new_usedip)

    def insert_ipinfo_to_t_used_ip(self):
        '''
        insert_ipinfo_to_T_USEDIPV4
        '''
        print("[insert_ipinfo_to_T_USEDIPV4] the size is:%d" % len(self.used_ip_paras))
        insert_stmt = "insert into T_USEDIPV4 (ID, IP, NETMASK, NEID, FDN, IPCONF," \
                      " ALLOCTYPE, UPDATETIME) values(:1,:2,:3,:4,:5,:6,:7,:8)"
        data_list = []
        for used_ip_para in self.used_ip_paras:
            data_list.append(IPAddressMigrate.fill_usedip_info(used_ip_para))
            if len(data_list) == ONE_PACKAGE:
                self.invbasedb_cursor.executemany(insert_stmt, data_list)
                print("[insert_iprange_into_T_USEDIPV4] one package datas:%s" % data_list)
                data_list = []

        if data_list:
            try:
                self.invbasedb_cursor.executemany(insert_stmt, data_list)
            except ValueError as err:
                print("[insert_iprange_into_T_USEDIPV4] ip_address insert_ipinfo_to_t_used_ip error")
            print("[insert_iprange_into_T_USEDIPV4] last package datas:%s" % data_list)

    def insert_ipinfo_to_invbase(self):
        '''
        insert_ipinfo_to_invbase
        '''
        print("[insert_ipinfo_to_invbase] start")
        self.insert_ipinfo_to_t_iprange()
        print("[insert_iprange_into_T_IPV4POOL] end")
        self.insert_ipinfo_to_t_used_ip()
        print("[insert_ipinfo_to_T_USEDIPV4] end")

    def close_session(self):
        '''
        close_session
        '''
        self.invbasedb_cursor.close()
        self.invbasedb_sess.close()
        self.topodb_cursor.close()
        self.topodb_sess.close()
        self.mcdb_cursor.close()
        self.mcdb_sess.close()

    def do_task(self):
        '''
        do the task
        '''
        try:
            print("[do]start to handle")
            self.get_nw_ip_range_info()
            print("get_ip range info and used ip_from_mcdb, start")
            self.get_nw_used_ip_info()
            print("[get_nw_used_ip_info]success !")
            self.convert_param()
            print("[convert_param]success !")
            self.insert_ipinfo_to_invbase()
            print("[insert_ipinfo_to_invbase]success !")
        except ValueError as err:
            self.close_session()
            print("[insert_ipinfo_to_invbase] ip_address.py: do_task error")

        self.close_session()

def UPDATE_FIBER_LINK(product_name="NCE"):
    inventory_sess = get_zenith_session('InventoryDB', 'InventoryDB', product_name)
    if inventory_sess is None:
        print("[UPDATE_FIBER_LINK]invbasedb_sess is None")
        return
    inventory_sess.autocommit(True)
    inventory_cursor = inventory_sess.cursor()
    print('get session success')

    sql_update = "update tbl_DiscreteLink set cName=CONCAT('l-',cId), " \
                 "cSourceType='NETWORK_ME' where cName = '' or cName is null"
    inventory_cursor.execute(sql_update)
    for sql in UPDATE_SQLS:
        try:
            print(datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S'))
            print('[UPDATE_FIBER_LINK] current sql:%s'%sql)
            inventory_cursor.execute(sql)
        except Exception as e:
            print('[UPDATE_FIBER_LINK] got exception,sql:%s'%sql)

    inventory_cursor.close()
    inventory_sess.close()

if __name__ == '__main__':
    if len(sys.argv) != 3:
        print('usage: python update_IPv4.py ')
        sys.exit(-1)
    product_name = sys.argv[2]
    print("ip_address product_name is %s" % product_name)
    TOOL = IPAddressMigrate(product_name)
    TOOL.do_task()
    print(' ')
    UPDATE_FIBER_LINK(product_name)
