#/bin/bash

##################################################
# Name        : exc_migrate_frame.sh
# Description : backup data from database
# param       : $1: "input" $2: Migrate Tools Path
# return      : 0 -- Everything OK; 1 -- Found Error
##################################################

cur_path=$(cd $(dirname $0);pwd)
tool_path=${cur_path}
log_path=${cur_path}/log
inv_tool_path=${cur_path}/../CP6313
if [ ! -d ${log_path} ]
then
    mkdir -p ${log_path}
fi
timeStamp=`date +"%Y%m%d%H%M%S"`
cur_log=${log_path}/exc_migrate_NCE_COMMON_${timeStamp}.log

echo "$(date +[%H:%M:%S])[INFO] start handle changed data..."
echo "$(date +[%H:%M:%S])[INFO] start handle changed data..." >> ${cur_log}

# 入参校验
function check_param()
{
    local check_tmp=$1
    [ -z "${check_tmp}" ] && return 1
    echo "${check_tmp}" | fgrep -q "../"
    if [ $? -eq 0 ]
    then
        echo "$(date +[%H:%M:%S])[INFO] The input param \"${check_tmp}\" is invalid."
        echo "$(date +[%H:%M:%S])[INFO] The input param \"${check_tmp}\" is invalid."  >> ${cur_log}
        return 1
    fi
    if [ ! -d "${check_tmp}" ]
    then
        echo "$(date +[%H:%M:%S])[INFO] The input param \"${check_tmp}\" is invalid."
        echo "$(date +[%H:%M:%S])[INFO] The input param \"${check_tmp}\" is invalid."  >> ${cur_log}
        return 1
    fi
}

# 获取输入参数
function init_params()
{
    local num=$#
    if [ $((${num}%2)) -eq 1 ]
    then
        num=$((${num}/2+1))
    else
        num=$((${num}/2))
    fi
    local count=1
    for((i=1;i<=${num};i++))
    do
        [[ ${1#-} == "input" ]] && { INPUTPATH=$2;shift 2;check_param "${INPUTPATH}" || return 1; continue; }
    done
}

#
function check_input()
{
    init_params "$@"
    if [ $? -ne 0 ]
    then
        echo "$(date +[%H:%M:%S])[INFO] check_input error,"
        echo "$(date +[%H:%M:%S])[INFO] check_input error," >> ${cur_log}
        return 1
    fi
}

# 获取脚本传入的产品名称
function get_productname()
{
    PRODUCT_NAME=$(cat ${INPUTPATH}/plandata.json 2>/dev/null | python -c "import json; import sys; obj=json.load(sys.stdin); print(obj['productname'])" 2>/dev/null)
    if [ -z "${PRODUCT_NAME}" ]
    then
        echo "$(date +[%H:%M:%S])[INFO] Productname is null."
        echo "$(date +[%H:%M:%S])[INFO] Productname is null." >> ${cur_log}
        return 1
    fi
}

check_input "$@" && get_productname
[ -z "${PRODUCT_NAME}" ] && PRODUCT_NAME="NCE"
echo "$(date +[%H:%M:%S])[INFO] PRODUCT_NAME is ${PRODUCT_NAME}"
echo "$(date +[%H:%M:%S])[INFO] PRODUCT_NAME is ${PRODUCT_NAME}" >> ${cur_log}

status_tncommondb=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'TNCOMMONDB'`
status_ucommondb=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'ucommonDB'`
status_U2000_IS=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'U2000_IS'`
status_InventoryDB=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'InventoryDB'`
status_MCDB=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'MCDB'`
status_UMDB=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'UMDB'`
status_DamDB=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'DamDB'`
status_OldMCDB=`cat /opt/upgrade/backup/migrate/old/containerlist.json |grep -w 'MCDB'`

# get the product_NCE.json
temp_neres_path=/opt/oss/log/manager/easysuite_upgrade/upgrade_neres/$timeStamp
mkdir -p $temp_neres_path
/opt/oss/manager/tools/resmgr/queryproduct.sh -pn ${PRODUCT_NAME} -output $temp_neres_path
status_FAN=`cat $temp_neres_path/product_${PRODUCT_NAME}.json |grep -w 'NCE-FAN'`
rm -rf $temp_neres_path

#migrate frameconf data
if [ "${status_MCDB}" ] && [ "${status_UMDB}" ] && [ "${status_DamDB}" ] && [ "${status_InventoryDB}" ];then
    echo "$(date +[%H:%M:%S])[INFO] Found database in NCE Env, start exec data backup by MigrateTool." >> ${cur_log}
    echo "$(date +[%H:%M:%S])[INFO] Begin migrate data..."
    echo "$(date +[%H:%M:%S])[INFO] Begin migrate data..." >> ${cur_log}
    if [ -f ${tool_path}/execute.sh ];then
        sh ${tool_path}/execute.sh online zenith null ${cur_path}/frameconf 1 1 CommonService
        if [ $? -ne 0 ];then
            echo "$(date +[%H:%M:%S])[ERROR] migrate data exec execute.sh failed. "
            echo "$(date +[%H:%M:%S])[ERROR] migrate data exec execute.sh failed. " >> ${cur_log}
            exit 1
        fi
    else
        echo "$(date +[%H:%M:%S])[ERROR][frameconf] No found MigrateTool execute.sh, please check."
        echo "$(date +[%H:%M:%S])[ERROR][frameconf] No found MigrateTool execute.sh, please check." >> ${cur_log}
        exit 1
    fi
    echo "$(date +[%H:%M:%S])[INFO] End migrate frameconf data..."
    echo "$(date +[%H:%M:%S])[INFO] End migrate frameconf data..." >> ${cur_log}
else
    echo "$(date +[%H:%M:%S])[INFO] No found database in NCE Env." >> ${cur_log}
fi
#migrate Inventory data
if [ "${status_InventoryDB}" ] && [ "${status_OldMCDB}" ];then
    echo "$(date +[%H:%M:%S])[INFO] Begin migrate Inventory data..."
    echo "$(date +[%H:%M:%S])[INFO] Begin migrate Inventory data..." >> ${cur_log}
    if [ -f ${tool_path}/execute.sh ];then
        sh ${tool_path}/execute.sh online zenith null ${cur_path}/phyInv 1 1 Inventory
        if [ $? -ne 0 ];then
            echo "$(date +[%H:%M:%S])[ERROR] migrate Inventory data exec execute.sh failed. "
            echo "$(date +[%H:%M:%S])[ERROR] migrate Inventory data exec execute.sh failed. " >> ${cur_log}
            exit 1
        fi
    else
        echo "$(date +[%H:%M:%S])[ERROR][Inventory] No found MigrateTool execute.sh, please check."
        echo "$(date +[%H:%M:%S])[ERROR][Inventory] No found MigrateTool execute.sh, please check." >> ${cur_log}
        exit 1
    fi
    echo "$(date +[%H:%M:%S])[INFO] End migrate Inventory data..."
    echo "$(date +[%H:%M:%S])[INFO] End migrate Inventory data..." >> ${cur_log}
else
    echo "$(date +[%H:%M:%S])[INFO] No found InventoryDB in NCE Env." >> ${cur_log}
fi

if [ -d /opt/oss/manager/apps/MCCommonService/ ]; then
    export APP_ROOT="/opt/oss/manager/apps/MCCommonService/"
else
    export APP_ROOT="/opt/oss/NCE/apps/MCService/"
fi
if [ -f ${APP_ROOT}/rtsp/mccommon/tools/shscript/app_profile.sh ];then
    . ${APP_ROOT}/rtsp/mccommon/tools/shscript/app_profile.sh
fi
if [ -f /opt/oss/manager/bin/engr_profile.sh ];then
    source /opt/oss/manager/bin/engr_profile.sh
else
    echo "$(date +[%H:%M:%S])[INFO] No found engr_profile.sh..."
    echo "$(date +[%H:%M:%S])[INFO] No found engr_profile.sh..." >> ${cur_log}
    exit 1
fi

CFG_PATH=${cur_path}/InvPhy_privilege_upgrade_template.json
backup_log_path=/opt/oss/log/manager/easysuite_upgrade/scriptlog
phyinv_log=${backup_log_path}/phyinv_${timeStamp}.log
if [ "${status_InventoryDB}" ];then
    echo "$(date +[%H:%M:%S])[INFO] Found privilege config in NCE Env ." >> ${phyinv_log}
    if [ -f "${inv_tool_path}/phyinv_web_privilege_upgrade.pyc" ]; then
        echo "pyc" >> ${phyinv_log}
        python ${inv_tool_path}/phyinv_web_privilege_upgrade.pyc ${inv_tool_path} ${CFG_PATH} ${PRODUCT_NAME} >> ${phyinv_log}
        ret=$?
        if [ $ret -ne 0 ];then
            echo "execute command [phyinv_web_privilege_upgrade.pyc] failed. error code is: "$ret >> ${phyinv_log}
            exit $ret
        fi
    else
        echo "py" >> ${phyinv_log}
        python ${inv_tool_path}/phyinv_web_privilege_upgrade.py ${inv_tool_path} ${CFG_PATH} ${PRODUCT_NAME} >> ${phyinv_log}
        ret=$?
        if [ $ret -ne 0 ];then
            echo "execute command [phyinv_web_privilege_upgrade.py] failed. error code is: "$ret >> ${phyinv_log}
            exit $ret
        fi
    fi
else
    echo "$(date +[%H:%M:%S])[INFO] No found privilege config in NCE Env." >> ${phyinv_log}
fi

echo "$(date +[%H:%M:%S])[INFO] start exc_common_tasks. PRODUCT_NAME is ${PRODUCT_NAME}" >> ${phyinv_log}
bash ./exc_common_tasks.sh ${PRODUCT_NAME} >> ${cur_log}
if [ $? -ne 0 ];then
    echo "$(date +[%H:%M:%S])[ERROR] exc_common_tasks.sh failed. "
    echo "$(date +[%H:%M:%S])[ERROR] exc_common_tasks.sh failed. " >> ${cur_log}
    exit 1
fi

echo "$(date +[%H:%M:%S])[INFO] End handle changed data..."
echo "$(date +[%H:%M:%S])[INFO] End handle changed data..." >> ${cur_log}

exit 0
