#!/usr/bin/python
# -*- coding: utf-8 -*-
import time
import traceback
import uuid

from getDBConnection import get_zenith_session
from common_tasks.base_task import BaseTask

ONE_PACKAGE = 500


class UpgradeQxDefaultUser(BaseTask):
    def __init__(self, product_name="NCE"):
        super(UpgradeQxDefaultUser, self).__init__()
        self.set_product_name(product_name)
        self.info("UpgradeQxDefaultUser init product_name is %s" % product_name)
        self.src_db_session = get_zenith_session('TransCommonDB', 'TransCommonDB', product_name)
        if self.src_db_session is None:
            self.error("TransCommonDB is None")
            return
        self.src_db_session.autocommit(True)
        self.src_db_cursor = self.src_db_session.cursor()

        self.dst_db_session = get_zenith_session('neresdb', 'neresdb', product_name)
        if self.dst_db_session is None:
            self.error("neresdb_sess is None")
            return
        self.dst_db_session.autocommit(True)
        self.dst_db_cursor = self.dst_db_session.cursor()

        self.src_table = "tbl_TransNVCfg"
        # 在查询源数据的方法中，确保返回的字段与这里定义的一致。
        self.src_table_cols = ("DefaultDCUserName", "DefaultDCPassword")
        self.src_table_cols_index = {y:x for x, y in enumerate(self.src_table_cols)}
        self.dst_table = "QxDefaultUser"
        self.dst_table_cols = ("modelId", "fModelId", "tenantId", "purpose", "userName", "password",
                               "createAt", "updateAt")
        self.idmapping_dic = {}

    def convert_data(self, paras):
        modelId = str(uuid.uuid1())
        fModelId = None
        tenantId = "default-organization-id"
        # TODO: 值待定，根据DC注册的用途名
        purpose = "DC"
        userName = paras[self.src_table_cols_index.get("DefaultDCUserName")]
        password = paras[self.src_table_cols_index.get("DefaultDCPassword")]
        createAt = str(int(time.time() * 1000))
        updateAt = str(int(time.time() * 1000))

        return tuple(x if x is None else str(x) for x in (modelId, fModelId, tenantId, purpose, userName, password,
                                                           createAt, updateAt))

    def to_UpgradePara(self, datas):
        col_names = "`" + ("`, `".join(self.dst_table_cols)) + "`"
        val_ids = ":" + (",:".join((str(x+1) for x in range(len(self.dst_table_cols)))))
        insert_stmt = "INSERT INTO `%s` (%s) VALUES(%s)" % (self.dst_table, col_names, val_ids)
        self.debug("insert sql stmt: %s" % insert_stmt)
        list_datas = []
        for data in datas:
            data = self.convert_data(data)
            if len(data) == len(self.dst_table_cols):
                list_datas.append(data)
            if len(list_datas) == ONE_PACKAGE:
                self.exec_sql(insert_stmt, list_datas)
                list_datas = []

        if len(list_datas) != 0:
            self.exec_sql(insert_stmt, list_datas)

    def close_session(self):
        self.dst_db_cursor.close()
        self.dst_db_session.close()
        self.src_db_cursor.close()
        self.src_db_session.close()

    def do(self):
        try:
            self.info('UpgradeQxDefaultUser::do start!')
            select_stmt = "select Name, Value from tbl_TransNVCfg"
            self.debug("execute sql: %s" % select_stmt)
            try:
                self.src_db_cursor.execute(select_stmt)
            except BaseException as be:
                self.warning("execute sql failed, err is: %s" % str(be))
                return 0
            key_values = dict(self.src_db_cursor.fetchall())
            datas = []
            if "DefaultDCUserName" in key_values and "DefaultDCPassword" in key_values:
                datas.append((key_values.get("DefaultDCUserName"), key_values.get("DefaultDCPassword")))

            self.info('get para data success count: %d' % len(datas))

            self.to_UpgradePara(datas)
            self.info('to_UpgradePara done')
            self.close_session()
        except Exception as e:
            self.close_session()
            self.error('UpgradeQxDefaultUser got exception')
            self.error(traceback.format_exc())
            return -1
        self.info('UpgradeQxDefaultUser::do done')
        return 0

if __name__ == '__main__':
    tool = UpgradeQxDefaultUser()
    print('[INFO] UpgradeQxDefaultUser start>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
    tool.do()
    print('[INFO] UpgradeQxDefaultUser finished<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<')
