#!/bin/bash
#check user
# űƶhfs_publicĿ¼µļ
cur_path=$(cd $(dirname $0);pwd)
timeStamp=`date +"%Y%m%d%H%M%S"`
cur_log=${cur_path}/pre_upgrade_MoveFile_${timeStamp}.log
undoversion=V100R020C10
srclist=V100R020C10SPC200
cplist=V100R020C10CP3
delversion=V100R021C00
function check_input()
{
    if [ "${1}" == "-input" -a -n "${2}" ]
    then
        INPUT_PATH=${2}
    else
        echo "ERROR The input param is invalid." >> ${cur_log}
        exit 1
    fi
}

# R21C00֮ǰ汾Ҫɾڵڵ
function delete_link_check()
{
    src_version=`cat ${INPUT_PATH}/plandata.json | grep src_version | tr '"' ' ' | awk '{print $3 }'` 
    echo "Upgrade src_version:[${src_version}]" >> ${cur_log}
    if [[ -n $src_version ]] && [[ $src_version < $delversion ]] ;then
        echo "need to delete link" >> ${cur_log}
    else
        echo "don't need to delete link" >> ${cur_log}
        exit 0
    fi
}

function init_env()
{
    now=`echo $(date "+%Y-%m-%d %H:%M:%S")`
    echo "${now}: Start execute pre_upgrade_MoveHFSFuse.sh >>>>>>>>>>>" >> ${cur_log}
    if [ -f /opt/oss/manager/bin/engr_profile.sh ];then
        source /opt/oss/manager/bin/engr_profile.sh
    else
        echo "$(date +[%H:%M:%S])[INFO] No found engr_profile.sh..." >> ${cur_log}
        exit 1
    fi
}

####ɾнڵµ /opt/backup/hfs/hfs_public link
function DelLink()
{
    adress=$1
    echo $adress >> ${cur_log}
    ssh ossadm@${adress} -oStrictHostKeyChecking=no > /dev/null 2>&1 << cmdoff
    echo "/bin/bash" > dellink.sh;sed 's/^/#!&/' -i dellink.sh;echo "if [ \"\`readlink /opt/backup/hfs/hfs_public\`\" == \"/opt/backup/ftpboot/hfs_public\" ];then">> dellink.sh;echo "    sudo -u ossuser rm -f /opt/backup/hfs/hfs_public">>dellink.sh;echo "fi">> dellink.sh;sh dellink.sh;exit
cmdoff
}
####ȡڵipϢ
function GetIpList()
{
    if [ -f "${cur_path}/check_environment.pyc" ];then
        nodelist=$({ echo -e "${OSS_ROOT}" ;}|python ${cur_path}/check_environment.pyc)
    elif [ -f "${cur_path}/check_environment.py" ];then
        nodelist=$({ echo -e "${OSS_ROOT}" ;}|python ${cur_path}/check_environment.py)
    else
        echo "No found check_environment.py, please check." >> ${cur_log}
        exit 1
    fi
    allip=$(echo "$nodelist"|grep alllist|awk -F '=' '{print $2}')
}
####ɾ
function DeleteLink()
{
    if [ -z "$allip" ];then
        echo "No found node ip info, please check." >> ${cur_log}
        exit 0
    else
        OLD_IFS="$IFS"
        IFS=","
        arr=($allip)
        for allip in ${arr[@]} ;do
            DelLink $allip &
        done
        IFS="$OLD_IFS"
    fi
}

check_input "$@"
delete_link_check
init_env
GetIpList
DeleteLink
echo "$(date "+%Y-%m-%d %H:%M:%S"): End execute pre_upgrade_MoveHFSFuse.sh <<<<<<<<<<<" >> ${cur_log}
exit 0
