﻿# coding: utf-8
"""
功 能：sopuser用户密码有效性检查
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import logging
import os

from utils.sshUtil import CsshCmd
from utils.sshUtil import SSHClient
from utils.thread_util import MultiThread
from utils.log_util import EasysuiteLogger
from easysuite import settings
from taskmgr.status_manager.sub_item_status_mgr import sub_item_decorate
from func.upgrade.common.upgrade_local_ssh import UpgradeLocalSsh

LOCAL_LOGGER = logging.getLogger(__name__)


def check_password_validity_period(kvs):
    """
    检查节点sopuser用户密码有效性
    """
    logger = EasysuiteLogger.get_logger(kvs, "task_check_password_validity_period")
    sub_item_mgr.save_single_sub_item("task_check_password_validity_period")
    logger.easysuite_start("begin to check")

    # 按站点检查sopuser密码有效性
    multi_thread = MultiThread()
    ssh_nodes_param = get_node_connect_info(kvs)
    for site, ssh_node in ssh_nodes_param.items():
        multi_thread.add_thread(check_password, ssh_node, logger)
    multi_thread.start()
    multi_thread.join()
    check_results = multi_thread.get()

    # 处理检查结果信息
    if False in check_results:
        sub_item_mgr.update_single_sub_item_status(logger, "error")
        return False
    logger.easysuite_finish("sopuser password check success.")
    sub_item_mgr.update_single_sub_item_status(logger, "finish")
    return True


def exec_check_sopuser_cmd(ssh_node):
    """
    执行检查命令
    :param ssh_node:
    :return:
    """
    cmd = 'offset_day=$(date -I -d "+30 day");' \
          'offset_num=$(date -d "${offset_day}" +%s);' \
          'expire=$(chage -l sopuser | grep "Password expires" | awk -F: "{print \$2}");' \
          'expire_num=$(date -d "${expire}" +%s);' \
          '[ ${offset_num} -gt ${expire_num} ] && ' \
          'echo "expired" || echo "okay"'
    if UpgradeLocalSsh.is_es_node(ssh_node.get("login_ip")):
        return UpgradeLocalSsh.send_admin_local_cmd(ssh_node.get("su_pawd"), cmd,
                                                    node_ip=ssh_node.get("login_ip"))
    return CsshCmd.exec_shell_cmd_su_root(ssh_node.get("login_ip"), ssh_node.get("login_user"),
                                          ssh_node.get("login_pawd"), cmd, ssh_node.get("su_pawd"),
                                          proxy_param=None)


def check_password(ssh_node, logger):
    """
    检查节点sopuser用户密码有效性
    """
    flag, check_result = exec_check_sopuser_cmd(ssh_node)
    if not flag:
        logger.easysuite_error("node %s Execute check scripts failed." % ssh_node.get("login_ip"))
        return False

    if check_result.find("okay") > -1:
        return True
    elif check_result.find("expired") > -1:
        logger.easysuite_error("node %s sopuser password expired risk，validity period is less than 30 days."
                               "Please log in to the management plane, If the current version is earlier than R21C00, "
                               "choose Maintenance > Change OS User Password, If the current version is R21C00 or "
                               "later, choose Maintenance > Enable OS User and Change Password from the main menu. "
                               "And creating a new EasySuiteOM Project" % ssh_node.get("login_ip"))
        return False
    logger.easysuite_error("node {0} sopuser password expired risk，check_result {1}."
                           "Please log in to the management plane, If the current version is earlier than R21C00, "
                           "choose Maintenance > Change OS User Password, If the current version is R21C00 or later, "
                           "choose Maintenance > Enable OS User and Change Password from the main menu. "
                           "And creating a new EasySuiteOM Project".format(ssh_node.get("login_ip"), check_result))
    return False


def get_node_connect_info(kvs):
    """
    获取管理节点登录信息
    """
    ssh_node_dict = {}
    login_user = kvs.get("standby_login_user")
    su_user = "root"
    # 非单管场景
    if kvs.get("single_mgr_domain") == "no":
        get_nms_node_info(kvs, login_user, ssh_node_dict, su_user)
    # 单管场景
    else:
        get_nce_x_node_info(kvs, login_user, ssh_node_dict, su_user)

    return ssh_node_dict


def get_nce_x_node_info(kvs, login_user, ssh_node_dict, su_user):
    """
    功能说明:获取非单管场景节点登录信息
    :param kvs:
    :param login_user:
    :param ssh_node_dict:
    :param su_user:
    :return:
    """
    master_node = {
        'login_ip': kvs.get('node_nmsserver_ip'),
        'login_user': login_user,
        'login_pawd': kvs.get('node_nmsserver_%s_pwd' % login_user),
        'su_user': su_user,
        'su_pawd': kvs.get('node_nmsserver_%s_pwd' % su_user),
        'ssh_port': kvs.get('node_nmsserver_ssh_port'),
        'sftp_port': kvs.get('node_nmsserver_sftp_port')
    }
    ssh_node_dict.update({"node": master_node})
    # 异地容灾场景
    if kvs.get("protection") == 'id_protection_hot':
        standby_node = {
            'login_ip': kvs.get('node_standby_nmsserver_ip'),
            'login_user': login_user,
            'login_pawd': kvs.get('node_standby_nmsserver_%s_pwd' % login_user),
            'su_user': su_user,
            'su_pawd': kvs.get('node_standby_nmsserver_%s_pwd' % su_user),
            'ssh_port': kvs.get('node_standby_nmsserver_ssh_port'),
            'sftp_port': kvs.get('node_standby_nmsserver_sftp_port')
        }
        ssh_node_dict.pop("node")
        ssh_node_dict.update({"master": master_node})
        ssh_node_dict.update({"standby": standby_node})


def get_nms_node_info(kvs, login_user, ssh_node_dict, su_user):
    """
    功能说明:获取单管场景节点登录信息
    :param kvs:
    :param login_user:
    :param ssh_node_dict:
    :param su_user:
    :return:
    """
    master_node = {
        'login_ip': kvs.get('node_omp01_ip'),
        'login_user': login_user,
        'login_pawd': kvs.get('node_omp01_%s_pwd' % login_user),
        'su_user': su_user,
        'su_pawd': kvs.get('node_omp01_%s_pwd' % su_user),
        'ssh_port': kvs.get('node_omp01_ssh_port'),
        'sftp_port': kvs.get('node_omp01_sftp_port')
    }
    ssh_node_dict.update({"node": master_node})
    # 异地容灾场景
    if kvs.get("protection") == 'id_protection_hot':
        standby_node = {
            'login_ip': kvs.get('node_standby_omp01_ip'),
            'login_user': login_user,
            'login_pawd': kvs.get('node_standby_omp01_%s_pwd' % login_user),
            'su_user': su_user,
            'su_pawd': kvs.get('node_standby_omp01_%s_pwd' % su_user),
            'ssh_port': kvs.get('node_standby_omp01_ssh_port'),
            'sftp_port': kvs.get('node_standby_omp01_sftp_port')
        }
        ssh_node_dict.pop("node")
        ssh_node_dict.update({"master": master_node})
        ssh_node_dict.update({"standby": standby_node})


def check(kvs):
    """
    功能描述：判断此任务是否需要执行
    :param kvs: 全局字典
    :return: 检查结果
    """
    login_user = kvs.get("standby_login_user", "")
    if login_user == "sopuser":
        return True
    return False


global sub_item_mgr


@sub_item_decorate
def exe(kvs):
    ret = list()
    result = check_password_validity_period(kvs)
    if result:
        ret.append([('', '', True)])
    else:
        ret.append([('', '', False)])
    return ret
