#!/bin/bash
WORKFORDER=$(dirname $(readlink -f $0))
RESULT_FILE="/var/log/sshd_check_result"
SUDO_PKG="/tmp/es_check_sudobin_pkg.tar"

# 修复老版本OS的sshd配置中"Match User dbuser" 缺少配对的"Match All"的问题
function complete_match_block(){
    cd ${WORKFORDER}
    bash complete_match_block.sh add_match_all
}

function check_sshd_config(){
    [ -f ${RESULT_FILE} ] && rm -f ${RESULT_FILE}
    local flag="true"
    local status=$(systemctl is-enabled sshd)
    if [ ${status} != "enabled" ]
    then
        flag="false"
        echo "[ERROR] the sshd service is not enable:" > "${RESULT_FILE}"
        echo "systemctl is-enabled sshd: ${status}" >> "${RESULT_FILE}"
    fi

    sshd -t &>> /dev/null
    if [ $? -ne 0 ]
    then
        flag="false"
        echo "[ERROR] execute 'sshd -t' failed:" >> "${RESULT_FILE}"
        sshd -t &>> "${RESULT_FILE}"
    fi

    if [ ${flag} != "true" ]
    then
        sed -i "1i sshd check failed, result:" "${RESULT_FILE}"
    else
        echo "check successfully" > "${RESULT_FILE}"
    fi
    #修改权限，使ossadm用户可读
    chmod 644 ${RESULT_FILE}
}

function clean_env(){
    rm -rf ${SUDO_PKG}
}

function main(){
    complete_match_block
    check_sshd_config
    clean_env
}

main "$*"
