#!/bin/bash
manager_master_db_ip=""
gaussdb_pwd=""
log_path="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
[ ! -e "${log_path}" ] && mkdir -p "${log_path}"
logfile="${log_path}/modify_flag.sh.log"
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
OSS_USER=$(id -nu 3001)

##########################################
#记录日志
##########################################
function record_log()
{
    msg="${1}"
    echo "$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)| ${msg}" >>${logfile}
}

##########################################
#获取脚本当前工作路径
##########################################
function getWorkPath()
{
    dir=$(dirname "$0")
    echo "${dir}" | grep "^/" >/dev/null 2>&1
    if [ $? -eq 0 ];then
        workfolder="${dir}"
        return 0
    fi
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "$ispointstart" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        workfolder="$(pwd)${dir}"
    elif [ "$ispointstart" == ".." ]
    then
        workfolder="$(pwd)/${dir}"
    else
        workfolder="$(pwd)/${dir}"
    fi
    return 0
}

##########################################
#检查脚本执行用户
##########################################
function check_user()
{
    local user
    user=$(whoami)
    if [ "${user}" != "${OSS_USER}" ]
    then
        echo "$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)| User have no permission to run this script"
        return 1
    fi
}

##########################################
#获取数据库信息
#@param 空
#   errorcode:   
#   201: 获取加密密文失败
#   202：解析密码失败
#   203：获取数据库IP失败
##########################################
function get_dbinfo()
{
    local manager_dbnum
    local record_file
    local tmp_count
    manager_db_type=${1}
    record_file="${log_path}/modify_flag_$(date +%s%N)".record
    
    /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -tenant manager -type ${manager_db_type}>"${record_file}"
    manager_dbnum=$(cat "${record_file}" | grep -cw "manager")
    if [ "${manager_dbnum}" -eq 1 ];then
        manager_master_db_ip=$(cat "${record_file}" | grep -w "manager" | awk '{print $6}')
    else
        manager_master_db_ip=$(cat "${record_file}" | grep -w "manager" | grep -w "Master" | awk '{print $6}')
    fi
    cat "${record_file}" >>"${logfile}" 2>&1
    for ((tmp_count=0; tmp_count<120; ++tmp_count))
    do
        sleep 5
        if [ -z "${manager_master_db_ip}" ];then
            record_log "Retry get manager_master_db_ip"
            /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -tenant manager -type ${manager_db_type}>"${record_file}"
            manager_dbnum=$(cat "${record_file}" | grep -cw "manager")
            if [ "${manager_dbnum}" -eq 1 ];then
                manager_master_db_ip=$(cat "${record_file}" | grep -w "manager" | awk '{print $6}')
            else
                manager_master_db_ip=$(cat "${record_file}" | grep -w "manager" | grep -w "Master" | awk '{print $6}')
            fi
            cat "${record_file}" >>"${logfile}" 2>&1
        else
            break
        fi
    done
    rm "${record_file}"
    if [ -z "${manager_master_db_ip}" ];then
        return 203
    fi
}

##########################################
#获取产品对应数据库节点nodeid
#@param product
#   errorcode:   
#   211: 获取节点ID失败
##########################################
function get_nodeid()
{
    local tmp_id=""
    node_id=""
    echo "${pkg}" | grep -E "_BigDataAnalyzerPatch_x86_64.tar.gz$|_ospatch_" >/dev/null 2>&1
    if [ $? -eq 0 ];then
        python_file=${workfolder}/pyscript/getipinfo.pyc
        if [ -f "${workfolder}"/pyscript/getipinfo.pyc ];then
            python_file=${workfolder}/pyscript/getipinfo.pyc
        elif [ -f "${workfolder}"/pyscript/getipinfo.py ];then
            python_file=${workfolder}/pyscript/getipinfo.py
        else
            record_log "getipinfo.py. not exist"
            return 1
        fi
        node_list=($(. /opt/oss/manager/bin/engr_profile.sh; python "${python_file}" "${product}" | sed 's/+/ /g'))
    else
        node_list=($(/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -tenant "${product}" -type zenith | grep -v "^DBInstanceId" | awk '{print $3}' | awk -F- '{print $2}' | sort -u ))
    fi
    for tmp_id in "${node_list[@]}"
    do
        [ -z "node_id" ] && node_id="${tmp_id}" || node_id="${node_id},${tmp_id}"
    done
    record_log "nodelist:${node_id}"
    if [ -z "${node_id}" ];then
        return 211
    fi
}

function check_args()
{
    action="${1}"
    product="${2}"
    pkg="${3}"
    if [ -z "${action}" ];then
        record_log "The input param (action) is incorrect."
        return 1
    fi
    if [ -z "${product}" ];then
        record_log "The input param (product) is incorrect."
        return 1
    fi
    if [ -z "${pkg}" ];then
        record_log "The input param (pkg) is incorrect."
        return 1
    fi
    if [ "${action}" != "query" -a "${action}" != "install" -a "${action}" != "uninstall" ];then
        record_log "The input param ${action} is incorrect.(query install uninstall)"
        return 1
    fi
    echo "The input param :modify_flag.sh ${action} ${product} ${pkg}"
    localpid=$$
    while true
    do
        ps -ef | grep -v grep | fgrep "modify_flag.sh" | grep "^ossadm" | head -1 | grep "^ossadm *${localpid}" >>${logfile} 2>&1
        if [ $? -eq 0 ];then
            break
        else
            sleep 1
        fi
    done
}

#总入口
function main()
{
    check_user
    getWorkPath
    check_args "$@" || return 1
    record_log "Start to modify_falg."
    record_log "The input param :modify_flag.sh ${action} ${product} ${pkg}"
    # 回滚数据库软件在管理面回滚之前,manager_db_type:zentih (升级目标版本为R20C10及以后版本)
    # 回滚数据库软件在管理面回滚之后,manager_db_type:gauss or zenith
    get_dbinfo 'zenith' || return $?
    get_nodeid || return $?
    if [ -f "${CUR_PATH}/pyscripts/connect_db.pyc" ]
    then
        connect_db_file="${CUR_PATH}/pyscripts/connect_db.pyc"
    else
        if [ -f "${CUR_PATH}/pyscripts/connect_db.py" ]
        then
            connect_db_file="${CUR_PATH}/pyscripts/connect_db.py"
        else
            return 999
        fi
    fi
    . /opt/oss/manager/bin/engr_profile.sh
    python ${connect_db_file} ${action} ${node_id} ${pkg} ${manager_master_db_ip}
}

main "$@"
result="$?"
record_log "Finsih to modify_falg"

if [ "${result}" -eq 203 ];then
    record_log "Failed to get database ip address"
    exit 203
elif [ "${result}" -eq 211 ];then
    record_log "Failed to get node ip"
    exit 211
elif [ "${result}" -eq 102 ];then
    exit 101
elif [ "${result}" -ne 0 ];then
    exit "${result}"
fi
exit 0

