#!/bin/bash
##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

##################################################
# 初始化日志路径和日志文件名
##################################################
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

##################################################
# 校验执行用户
# 脚本要求使用root用户执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

check_user || exit $?

. ${SCRIPT_PATH}/common.sh
LOG "INFO" "Start to init ${LOG_FILE}."
. /opt/oss/manager/bin/engr_profile.sh
pyscript="${SCRIPT_PATH}/pyscripts/operate_schedule.py"
if [ ! -f "${pyscript}" ]
then
    pyscript="${SCRIPT_PATH}/pyscripts/operate_schedule.pyc"
fi