#!/bin/bash

SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"


##################################################
# 校验执行用户
# 脚本要求使用oss用户执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

##################################################
# 日志记录进/opt/oss/log/manager/easysuite_upgrade/scriptlog/${SELF_FILE}.log
##################################################
function LOG()
{
    BASH_PID=$$
    if [ "$1" = "ERROR" -o "$1" = "error" ]
    then
        Level="ERROR"
    elif [ "$1" = "WARN" -o "$1" = "warn" ]
    then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${BASH_PID}] | ${Level} $2" | tee -a ${LOG_FILE}
}

# 入参校验
function check_param()
{
    local check_tmp=$1
    [ -z "${check_tmp}" ] && return 1
    echo "${check_tmp}" | fgrep -q "../"
    if [ $? -eq 0 ]
    then
        LOG "ERROR" "The input param \"${check_tmp}\" is invalid."
        return 1
    fi
    if [ ! -d "${check_tmp}" ]
    then
        LOG "ERROR" "The input param \"${check_tmp}\" is invalid."
        return 1
    fi
}

# 获取输入参数
function init_params()
{
    local num=$#
    if [ $((${num}%2)) -eq 1 ]
    then
        num=$((${num}/2+1))
    else
        num=$((${num}/2))
    fi
    local count=1
    for((i=1;i<=${num};i++))
    do
        [[ ${1#-} == "input" ]] && { INPUTPATH=$2;shift 2;check_param "${INPUTPATH}" || return 1; continue; }
    done
}

function check_input()
{
    init_params "$@"
    if [ $? -ne 0 ]
    then
        echo "Example: bash ${SELF_FILE} -input /opt/upgrade/easysuite_upgrade/workpath/V100R019C00SPC602-V100R020C00/workpath-NCE/"
        return 1
    fi
}

# 刷新备份恢复数据库信息
function fresh()
{
    PRODUCTNAME=$(cat ${INPUTPATH}/plandata.json 2>/dev/null | python -c "import json; import sys; obj=json.load(sys.stdin); print(obj['productname'])" 2>/dev/null)
    if [ -z "${PRODUCTNAME}" ]
    then
        LOG "ERROR" "Failed to obtain product information."
        return 1
    fi
    LOG "INFO" "Start to fresh backup restore information."
    python >>"${LOG_FILE}" 2>&1 << PEND
from util import common,httpclient
import time,sys
client=httpclient.IRHttpClient()
url="/rest/plat/brmgr/v1/global/reschangenotify/product"
body={'productName':'${PRODUCTNAME}'}
print("body:%s" % body)
for i in range(0,2):
    status,response=client.post(url, body)
    print("status:%s,response:%s" % (status, response))
    if status == 200:
        break
    time.sleep(1)
if status != 200:
    sys.exit(1)
sys.exit(0)
PEND
    if [ $? -eq 1 ]
    then
        LOG "ERROR" "Failed to fresh backup restore information."
        return 1
    fi
    LOG "INFO" "Finished to fresh backup restore information."
}

function main()
{
    check_user || return 1
    # 创建日志目录
    [ ! -d "${LOG_PATH}" ] && mkdir -p ${LOG_PATH}
    . /opt/oss/manager/bin/engr_profile.sh
    check_input "$@" || return 1
    fresh || return 1
}

main "$@"
exit $?