#!/bin/bash
#/opt/oss/tmp 目录,对24小时没有访问过的文件清理
tmpPath="/opt/oss/manager/apps/SMPAgentService/script/clear_oss_tmp.sh"

function get_all_ips()
{
    # first use SMPAgentService's python, otherwise use one of rtsp's
    pythonBin="/opt/oss/manager/apps/SMPAgentService/rtsp/python/bin/python"
    if [ ! -f "$pythonBin" ]; then
        pythonBin=$(ls "${INSTALL_ROOT}"/rtsp/python*/bin/python |tail -n 1)
    fi

    cat <<EOF | $pythonBin
#-*-coding:utf-8-*-
import os
import json

try:
    nodelist_file=os.path.join(os.getenv("INSTALL_ROOT", "/opt/oss"), "manager", "etc", "sysconf", "nodelists.json")
    with open(nodelist_file) as f:
        data=json.load(f, encoding="utf-8")
        for _,node in data['nodeList'].items():
            if 'MGR' in node['role']:
                for ip in node['IPAddresses']:
                        if 'maintenance' in ip['usage']:
                                print(ip['IP'])
                                break
except Exception as e:
    print(e)
finally:
    pass
EOF
}

for nodeip in $(get_all_ips)
do
    ssh $nodeip >/dev/null 2>&1 <<EOF
	if [ -f "$tmpPath" ]; then
		rm -f $tmpPath
	fi
EOF
done

exit 0